unit InputUnit;

interface

uses
  Classes;

type
  TInputReaderThread = class(TThread)
  private
    TheLine: string;
    procedure SendLine;
  protected
    procedure Execute; override;
  public
    PassThrough: Boolean;
  end;

implementation

uses
  Windows, MainUnit;

{ Important: Methods and properties of objects in VCL can only be used in a
  method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TInputReaderThread.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TInputReaderThread }

procedure TInputReaderThread.SendLine;
begin
  Main.NewLine(TheLine);
  TheLine:='';
end;

procedure TInputReaderThread.Execute;
var
  HS, OS: THandleStream;
  Ch: Char;
  S: string;
begin
  HS:=THandleStream.Create(GetStdHandle(STD_INPUT_HANDLE));
  if PassThrough then OS:=THandleStream.Create(GetStdHandle(STD_OUTPUT_HANDLE));
  S:='';
  while True do begin
    if HS.Read(Ch, 1)=1 then begin
      if PassThrough then OS.Write(Ch, 1);
      if (Ch <> #13) and (Ch <> #10) then S:=S + Ch;
      if Ch=#10 then begin
        TheLine:=S;
        S:='';
        Synchronize(SendLine);
      end;
    end else Sleep(1);
  end;
end;

end.
