#include <Windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

LPSTR NameTable[] = {"back", "tab", "clear", "return", "shift", "control", "alt", "pause",
"capital", "escape", "space", "pageup", "pagedown", "end", "home", "left",
"up", "right", "down", "select", "print", "execute", "printscreen",
"insert", "delete", "help", "lwin", "rwin", "apps", "numpad0", "numpad1",
"numpad2", "numpad3", "numpad4", "numpad5", "numpad6", "numpad7", "numpad8",
"numpad9", "multiply", "add", "separator", "subtract", "decimal", "divide",
"f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12",
"f13", "f14", "f15", "f16", "f17", "f18", "f19", "f20", "f21", "f22", "f23",
"f24", "numlock", "scroll", "lshift", "rshift", "lcontrol", "rcontrol",
"lalt", "ralt", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", 
"o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", 
"2", "3", "4", "5", "6", "7", "8", "9"};
BYTE VKTable[] = {0x08, 0x09, 0x0C, 0x0D, 0x10, 0x11, 0x12, 0x13, 0x14, 0x1B, 0x20, 
0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 
0x2C, 0x2D, 0x2E, 0x2F, 0x5B, 0x5C, 0x5D, 0x60, 0x61, 0x62, 0x63, 
0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 
0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 
0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x84, 
0x85, 0x86, 0x87, 0x90, 0x91, 0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
82, 83, 84, 85, 86, 87, 88, 89, 90, 48, 49, 50, 51, 52, 53, 54, 55, 
56, 57};
BOOL Down[sizeof(VKTable)];
HWND WndToRestore;

enum {EXACT, PART, PREFIX, SUFFIX};

void Lowerize(LPSTR s)
{
    for (;*s;s++) *s = tolower(*s);
}

void ActivateTheWindow(LPSTR cap, int mode)
{
    HWND w = GetWindow(GetDesktopWindow(), GW_CHILD);
    Lowerize(cap);
    while (w)
    {
        BOOL ok = FALSE;
        if (IsWindowVisible(w))
        {
            DWORD len = GetWindowTextLength(w);
            LPSTR text = malloc(len + 2);
            GetWindowText(w, text, len + 1);
            while (isspace(text[0])) memmove(text, text + 1, len);
            while (text[0] && isspace(text[len])) text[len--] = 0;
            Lowerize(text);
            switch (mode)
            {
            case EXACT:
                ok = !strcmp(text, cap);;
                break;
            case PART:
                ok = !!strstr(text, cap);
                break;
            case PREFIX:
                if (strlen(cap) <= strlen(text))
                {
                    ok = !strncmp(text, cap, strlen(cap));
                }
                break;
            case SUFFIX:
                if (strlen(cap) <= strlen(text))
                {
                    ok = !strcmp(cap, text + (strlen(text) - strlen(cap)));
                }
                break;
            }
            free(text);
        }
        if (ok)
        {
            HWND hCurWnd = GetForegroundWindow();
            DWORD dwMyID = GetCurrentThreadId();
            DWORD dwCurID = GetWindowThreadProcessId(hCurWnd, NULL);
            AttachThreadInput(dwCurID, dwMyID, TRUE);
            SetWindowPos(w, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
            SetWindowPos(w, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
            SetForegroundWindow(w);
            AttachThreadInput(dwCurID, dwMyID, FALSE);
            SetFocus(w);
            SetActiveWindow(w);
            WndToRestore = hCurWnd;
            return;
        }
        w = GetWindow(w, GW_HWNDNEXT);
    }
    fprintf(stderr, "Warning: failed to find the specified window\n");
}

int main(int argn, char** argv)
{
    char* spec = malloc(1);
    int i;
    BOOL autorelease = TRUE, refocus = TRUE;
    spec[0] = 0;
    for (i=1; i < argn; i++)
    {
        if (!strcmp(argv[i], "-r"))
        {
            autorelease = FALSE;
        }
        else if (!strcmp(argv[i], "-f"))
        {
            refocus = FALSE;
        }
        else if (!strcmp(argv[i], "-d"))
        {
            Sleep(atoi(argv[++i]));
        }
        else if (!strcmp(argv[i], "-w"))
        {
            ActivateTheWindow(argv[++i], EXACT);
        }
        else if (!strcmp(argv[i], "-m"))
        {
            ActivateTheWindow(argv[++i], PART);
        }
        else if (!strcmp(argv[i], "-p"))
        {
            ActivateTheWindow(argv[++i], PREFIX);
        }
        else if (!strcmp(argv[i], "-s"))
        {
            ActivateTheWindow(argv[++i], SUFFIX);
        }
        else if (!strcmp(argv[i], "--help"))
        {
            puts("Usage: sendkeys [-w window caption] [-d ms] [-f] [-r] <keys>");
            puts(" or:   sendkeys [-m window caption part] [-d ms] [-f] [-r] <keys>");
            puts(" or:   sendkeys [-p window caption prefix] [-d ms] [-f] [-r] <keys>");
            puts(" or:   sendkeys [-s window caption suffix] [-d ms] [-f] [-r] <keys>");
            puts("The keys can be something like: +KEY or -KEY to press or release a key");
            puts("  if neither + nor - is given then two events will be issued, one for");
            puts("  press and another for release. A $ can be used to insert a delay");
            puts("  in millseconds between key presses (e.g. A $1000 B will delay one");
            puts("  second between A and B).");
            puts("Unless -r is specified, after keys have been processed, any +KEY");
            puts("  that didn't have a -KEY will be followed by an implicit -KEY in the");
            puts("  reverse order that was specified (e.g. sendkeys +CONTROL+A will");
            puts("  actually send the equivalent of +CONTROL+A-A-CONTROL).");
            puts("If -w, -m, -p or -s is specified, the window that contains the given");
            puts("  caption (or part of it) will be focused before sending the keys.");
            puts("If -d is specified, sendkeys will wait for ms milliseconds. If -d is");
            puts("  used before -w/-m/-p/-s the delay will occur before activating the");
            puts("  window and if it is used after, it will occur before sending the");
            puts("  first keys (this is essentially the same as starting the keys with");
            puts("  $ and the number of milliseconds in -d).");
            puts("Unless -f is specified, after the keys have been send, the window");
            puts("  that was focused before will be focused again.");
            puts("Use --keys to get a list of known keys.");
            return 0;
        }
        else if (!strcmp(argv[i], "--keys"))
        {
            puts("Known key names:");
            for (i=0; i < sizeof(VKTable); i++)
                puts(NameTable[i]);
            return 0;
        }
        else
        {
            spec = realloc(spec, strlen(spec) + strlen(argv[i]) + 2);
            strcat(spec, argv[i]);
            strcat(spec, " ");
        }
    }
    if (!spec[0])
    {
        fprintf(stderr, "No keys, use sendkeys --help for usage info.");
        return 1;
    }
    i = 0;
    while (spec[i])
    {
        BOOL up = FALSE, down = FALSE;
        int j, b;
        while (spec[i] && isspace(spec[i])) i++;
        if (!spec[i]) break;
        if (spec[i] == '$')
        {
            j = 0;
            i++;
            while (isdigit(spec[i]))
            {
                j = j*10 + spec[i] - '0';
                i++;
            }
            Sleep(j);
            continue;
        }
        if (spec[i] == '+') down = TRUE;
        else if (spec[i] == '-') up = TRUE;
        else up = down = TRUE;
        if (!up || !down) i++;
        b = i;
        while (spec[i] && isalnum(spec[i]))
        {
            spec[i] = tolower(spec[i]);
            i++;
        }
        for (j=0; j < sizeof(VKTable); j++)
        {
            char tmp = spec[i];
            spec[i] = 0;
            if (!strcmp(NameTable[j], spec + b))
            {
                if (down)
                {
                    keybd_event(VKTable[j], (BYTE)MapVirtualKey(VKTable[j], 0),
                        0, 0);
                    Down[j] = TRUE;
                }
                if (up)
                {
                    keybd_event(VKTable[j], (BYTE)MapVirtualKey(VKTable[j], 0),
                        KEYEVENTF_KEYUP, 0);
                    Down[j] = FALSE;
                }
                spec[i] = tmp;
                break;
            }
            spec[i] = tmp;
        }
        if (j == sizeof(VKTable))
        {
            spec[i] = 0;
            fprintf(stderr, "unknown key name: '%s'\n", spec + b);
            return 1;
        }
    }
    if (autorelease)
    {
        for (i=sizeof(VKTable) - 1; i >= 0; i--)
            if (Down[i])
            {
                keybd_event(VKTable[i], (BYTE)MapVirtualKey(VKTable[i], 0),
                        KEYEVENTF_KEYUP, 0);
            }
    }
    if (refocus && WndToRestore)
    {
        HWND hCurWnd = GetForegroundWindow();
        DWORD dwMyID = GetCurrentThreadId();
        DWORD dwCurID = GetWindowThreadProcessId(hCurWnd, NULL);
        AttachThreadInput(dwCurID, dwMyID, TRUE);
        SetWindowPos(WndToRestore, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
        SetWindowPos(WndToRestore, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
        SetForegroundWindow(WndToRestore);
        AttachThreadInput(dwCurID, dwMyID, FALSE);
        SetFocus(WndToRestore);
        SetActiveWindow(WndToRestore);
    }
    return 0;
}
