{*
 * Outliner Lighto
 * Copyright (C) 2011 Kostas Michalopoulos
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * Kostas Michalopoulos <badsector@runtimeterror.com>
 *}
unit Tree;
interface
{$MODE OBJFPC}{$H+}
uses SysUtils, Nodes, Defines;

var
  Root: TNode;

procedure CreateTree;
procedure DestroyTree;
function SaveTree(FileName: string; Root: TNode): Boolean;
function LoadTree(FileName: string; var Root: TNode): Boolean;

implementation

procedure CreateTree;
var
  Node: TNode;
  NodeStack: array [0..256] of TNode;
  NSP: Integer;
begin
  Root:=TNode.Create;
  Node:=Root;
  NSP:=0;
  { === CUTCUT === The code below is generated with olol2pas === CUTCUT === }
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Welcome to Outliner Lighto');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Outliner Lighto is a small outliner program for the console. An outliner progr' + 
    'am is simply a program that edits text structured in tree nodes. These nodes ca' + 
    'n be used for any purpose the user wants, like TODO lists, phonebooks, etc. Any' + 
    'thing that can be represented by a hierarchy can be stored in an outliner.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('When working with Outliner Lighto you always have a "selected node", which is ' + 
    'the node you are currently working with.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Use the arrow keys or hjkl (as in Vi) to change the selected node.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Going up and down always move to the previous and next node in the current nod' + 
    'e''s parent node.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Going left and right will "rise" from and "dive" into the node structure.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Using C or Enter you can edit the selected node. With I and A you can add new ' + 
    'nodes.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('By pressing the Space bar you can open and close nodes with subnodes.');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Diving into a node will open it temporarily.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Select this node and dive into it (with the above node selected, press Down or' + 
    ' j and then Right or l) for more tips.');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Think of the outline as a tree:');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('There are branches (nodes) which in turn have more branches (sub-nodes)');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('And at the end of the branches there are leaves (nodes without subnodes)');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Leaf nodes are always shown as white text with a blue ''o'' in front of them. Yo' + 
    'u can also think of them as ''bullets'' in a list.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Branch nodes are shown in color with different colors depending on how "deep" ' + 
    'in the structure the node is.');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('The different colors are used to distinguish between the depths when there are' + 
    ' many open branches on screen.');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Like');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('This');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Trying to move below the last node will create a temporary node at the end. By' + 
    ' editing this node you can make it permanent.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('When adding a new node via A, I or using the method described above, Outliner ' + 
    'Lighto will create new nodes continuously until you don''t make one permanent by' + 
    ' editing it. This way you can enter many new nodes in a row.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Other tasks');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Editing text (the Edit Mode)');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('By pressing C or Enter you will enter in "Edit Mode". In this mode you can edi' + 
    't the node''s text just by typing it. You can also use the following keys while ' + 
    'in this mode:');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Arrows will move you around');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Home will move you at the beginning of the text');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('End will move you at the end of the text');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Esc will cancel the edit. In some cases when a new node is being edited (like ' + 
    'when adding many items in a row via A or I) this will remove the node (don''t wo' + 
    'rry, the node will be removed only if there was no text in it)');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Delete will delete the character under the cursor');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Backspace will delete the character at the left and move the cursor there');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Deleting and Pasting nodes');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Using the D or Delete keys you can delete a node (you need to confirm the dele' + 
    'tion by pressing D or Delete again). When the node is deleted, it is not remove' + 
    'd completely from the memory but kept around to be pasted in some other place i' + 
    'n the tree.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Using the P key you can paste a previously deleted node above the selected nod' + 
    'e. If the selected node is a temporary node created by Outliner Lighto without ' + 
    'text then the previously deleted node replaces the temporary node.');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('You can use the P key multiple times, each time you create a new copy of the d' + 
    'eleted node. This can be used to create multiple duplicates of a node by first ' + 
    'deleting it and then pasting it multiple times in place by pressing P.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Note that if you delete two nodes, the first node will be lost. Outliner Light' + 
    'o remembers only the last deleted node.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Moving nodes around (the Grab Mode)');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('By pressing G you enter in the "Grab Mode" which you can use to move the selec' + 
    'ted node around the node hierarchy (think of it as grabbing the node from the h' + 
    'ierarchy and moving it around). While in Grab Mode the following keys apply:');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('In grab mode you use the arrow keys (sorry, no hjkl for the moment) to move th' + 
    'e node like you would change the selected node. With the up/down arrows you mov' + 
    'e the node in the same level. With the left/right arrows you demote and promote' + 
    ' the node in the hierarchy.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('To drop the node (leave the tree as you see it with the node at the point it i' + 
    's now), press G or Enter.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('To cancel the operation and restore the tree as it was, press Escape.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Searching for text');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Using the / key you can search for any text in any node, starting from the nex' + 
    't node.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Outliner Lighto remembers your last search so you can use U (or Home) and / an' + 
    'd Enter to search the entire tree for all occurrences of some text.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Displaying nodes as flowing text / paragraphs');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Using the F key you can display the text of the current node and all of its ch' + 
    'ildren and their children as "flowing text" (text that "flows" as if in a print' + 
    'ed page).');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('This can be useful when a node is supposed to represent the paragraphs of a do' + 
    'cument (or even a section) to make the text closer to how it would appear in a ' + 
    'page.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('To try this out, select the "Displaying nodes as flowing text / paragraphs" no' + 
    'de (the parent of this nodee) and press the F key. All the subnodes will be dis' + 
    'played as regular text.');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Use the F key again or the Escape key to return to normal mode.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Creating "tickable" nodes for automatic TODO lists, etc');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('To change the type of a node, press T. This will switch it between "normal" an' + 
    'd "tickable".');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('A tickable leaf node can be ticked and unticked using X.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('A tickable node with children is only ticked when all of its children are tick' + 
    'ed. Otherwise a percentage of the ticked children is shown with a different col' + 
    'or depending on the progress.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Example');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Stuff to do');
  Node.NodeType:=ntTickable;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Make coffee');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Node.Open:=True;
  Node.WasOpen:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Clean the house');
  Node.NodeType:=ntTickable;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Clean the office');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Clean the kitchen');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Clean the hall');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Rest a bit');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Cook something');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Clean the dishes');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Write some code');
  Node.NodeType:=ntTickable;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Go online');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Spend time on Reddit');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Spend time on YouTube');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Spend time on MSN');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Spend time on Wikipedia');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Read email');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Implement the missing functionality');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('A normal (non-tickable) leaf inside a tickable node will have a double dash in' + 
    ' front of it and use a brighter color. This can be used to separate items in a ' + 
    'list without adding further hierarchy.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Example');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('To buy');
  Node.NodeType:=ntTickable;
  Node.Tick:=True;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('From the first level');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Meat');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Cheese');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Sugar');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('From the second level');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Milk');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Coffee');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Rice');
  Node.NodeType:=ntTickable;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Creating "pointers" to other nodes');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Use the . (period) key to create a "pointer" to the currently selected node. A' + 
    ' pointer node looks and behaves like the node it points to but can be placed an' + 
    'ywhere else in the tree.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('For example the node below is a pointer to the "Editing text" node above.');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Editing text (the Edit Mode)');
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Any modification to the pointed node will be reflected automatically to all po' + 
    'inter nodes.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Be careful about placing pointers inside the nodes they point!');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Scripting');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Outliner Lighto supports simple scripting using the LIL (Little Interpreted La' + 
    'nguage) scripting language. This is a compact yet powerful language meant to be' + 
    ' used by applications to extend their functionality.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('LIL provides a few of its own commands, like "if", "list", etc which are docum' + 
    'ented as part of LIL''s own documentation.');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('LIL can be found at http://runtimeterror.com/tech/lil');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Outliner Lighto adds a few commands of its own to manipulate the nodes in the ' + 
    'outline tree and provide a few user interface utilities.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('To run a LIL command press the E key, type some code and press Enter.');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Try it, press E and type: ask ''What is your name?''');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('When Outliner Lighto starts it tries to run a LIL script from your home direct' + 
    'ory called .ol.lil (placed alongside the default .ol.olol outline file). You ca' + 
    'n place any script code you want in this file.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('For details see the scripts.txt file.');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('About');
  Node.NodeType:=ntNormal;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('Outliner Lighto was made by Kostas "Bad Sector" Michalopoulos');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('It was made in Free Pascal');
  Node.NodeType:=ntNormal;
  Node.Open:=True;
  Node.WasOpen:=True;
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('http://freepascal.org');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('You can find it at http://runtimeterror.com/tools/ol');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('You can email me at badsector@runtimeterror.com');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  NodeStack[NSP]:=Node;
  Inc(NSP);
  Node:=Node.AddStr('The program was inspired from "Hierarchical Notebook" by 0yvind Kolas');
  Node.NodeType:=ntNormal;
  Dec(NSP);
  Node:=NodeStack[NSP];
  Dec(NSP);
  Node:=NodeStack[NSP];
  { === CUTCUT === The code above is generated with olol2pas === CUTCUT === }
end;

procedure DestroyTree;
begin
  FreeAndNil(Root);
end;

function SaveTree(FileName: string; Root: TNode): Boolean;
var
  f: TextFile;
begin
  Assign(f, FileName);
  {$I-}
  ReWrite(f);
  {$I+}
  if IOResult <> 0 then Exit(False);
  Result:=True;
  WriteLn(f, 'NOTE');
  WriteLn(f, 'NOTE Saved by Outliner Lighto version ', VERSION);
  WriteLn(f, 'NOTE');
  Root.Save(f);
  WriteLn(f, 'STOP');
  Close(f);
end;

function LoadTree(FileName: string; var Root: TNode): Boolean;
var
  f: TextFile;
  s, Cmd: string;

  function FindTarget(Addr: string): TNode;
  var
    Parts: array of Integer;
    s: string = '';
    i: Integer;
  begin
    Addr:=Trim(Addr);
    if Addr='' then Exit(nil);
    SetLength(Parts, 0);
    for i:=1 to Length(Addr) do begin
      if Addr[i] in [' ', #9] then begin
        if s <> '' then begin
          SetLength(Parts, Length(Parts) + 1);
          try
            Parts[Length(Parts) - 1]:=StrToInt(s);
          except
            Result:=nil;
            Exit;
          end;
          s:='';
        end;
      end else if Addr[i] in ['0'..'9'] then begin
        s:=s + Addr[i];
      end;
    end;
    if s <> '' then begin
      SetLength(Parts, Length(Parts) + 1);
      try
        Parts[Length(Parts) - 1]:=StrToInt(s);
      except
        Result:=nil;
        Exit;
      end;
    end;
    Result:=Root;
    for i:=0 to Length(Parts) - 1 do begin
      if (Parts[i] >= 0) and (Parts[i] < Length(Result.Children)) then Result:=Result.Children[Parts[i]] else Exit(nil);
    end;
    if Result=Root then Result:=nil;
  end;

  procedure FixTarget(ANode: TNode);
  var
    i: Integer;
  begin
    if ANode.NodeType=ntPointer then
      ANode.Target:=FindTarget(ANode.TargetAddress)
    else begin
      for i:=0 to Length(ANode.Children) - 1 do FixTarget(ANode.Children[i]);
    end;
  end;

begin
  Assign(f, FileName);
  {$I-}
  Reset(f);
  {$I+}
  if IOResult <> 0 then Exit(False);
  Result:=True;
  DestroyTree;
  while not Eof(f) do begin
    Readln(f, s);
    if Length(s) < 4 then continue;
    Cmd:=Copy(s, 1, 4);
    if Cmd='STOP' then break;
    if Cmd='NODE' then begin
      FreeAndNil(Root);
      Root:=TNode.Create;
      Root.Load(f);
    end;
  end;
  Close(f);
  FixTarget(Root);
end;

initialization
  Root:=nil;
end.
