{*
 * tab2olol - utility that converts tab-indented text files to olol files
 * Copyright (C) 2011 Kostas Michalopoulos
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * Kostas Michalopoulos <badsector@runtimeterror.com>
 *}
program tab2olol;
{$MODE OBJFPC}{$H+}
var
  f: Text;
  s: string;
  i, LastTabs, Tabs: Integer;
begin
  if ParamCount=0 then begin
    Writeln('Usage: tab2olol <tab file>');
    exit;
  end;
  Assign(f, ParamStr(1));
  {$I-}
  Reset(f);
  {$I+}
  if IOResult <> 0 then begin
    Writeln('Failed to open ', ParamStr(1), ' for input');
    exit;
  end;
  WriteLn('NOTE');
  WriteLn('NOTE Created from ', ParamStr(1), ' by tab2olol');
  WriteLn('NOTE');
  WriteLn('NODE');
  LastTabs:=-1;
  while not Eof(f) do begin
    Readln(f, s);
    if s='' then continue;
    Tabs:=0;
    for i:=1 to Length(s) do
      if s[i]=#9 then
        Inc(Tabs)
      else
        break;
    for i:=Tabs to LastTabs do WriteLn('DONE');
    WriteLn('NODE ', Copy(s, Tabs + 1, Length(s)));
    LastTabs:=Tabs;
  end;
  WriteLn('DONE');
  WriteLn('STOP');
  Close(f);
end.
