unit StackInspectorUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Cards;

type

  { TStackInspector }

  TStackInspector = class(TForm)
    cbScriptEvent: TComboBox;
    lbScript: TLabel;
    mCode: TMemo;
    procedure cbScriptEventChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure mCodeChange(Sender: TObject);
  private
    FStack: TStack;
    ShownPreviously: Boolean;
    procedure SetStack(const AValue: TStack);
  public
    property Stack: TStack read FStack write SetStack;
  end; 

var
  StackInspector: TStackInspector;

implementation

uses
  UIMisc, ScriptingUI;

{$R *.lfm}

{ TStackInspector }

procedure TStackInspector.FormShow(Sender: TObject);
var
  X, Y: Integer;
begin
  if not ShownPreviously then begin
    X:=Application.MainForm.Left + Application.MainForm.Width + 20;
    if X > Screen.Width - Width - 20 then X:=Screen.Width - Width - 20;
    Y:=Application.MainForm.Top + (Application.MainForm.Height div 2 + 20);
    if Y + Height > Screen.DesktopHeight - 50 then Y:=Screen.DesktopHeight - Height - 50;
    Left:=X;
    Top:=Y;
    SetupCodeFont(mCode.Font);
    ShownPreviously:=True;
  end;
end;

procedure TStackInspector.mCodeChange(Sender: TObject);
begin
  if Assigned(Stack) then Stack.ScriptHandlerSet.SetHandlerCode(HandlerNameOnly(cbScriptEvent.Text), mCode.Text);
end;

procedure TStackInspector.cbScriptEventChange(Sender: TObject);
begin
  if Assigned(Stack) then mCode.Text:=Stack.ScriptHandlerSet.GetHandlerCode(HandlerNameOnly(cbScriptEvent.Text));
end;

procedure TStackInspector.SetStack(const AValue: TStack);
begin
  if FStack=AValue then Exit;
  FStack:=AValue;
  if Assigned(Stack) then begin
    FillComboBoxWithHandlers(cbScriptEvent, Stack.ScriptHandlerSet);
    cbScriptEventChange(cbScriptEvent);
  end else begin
    mCode.Text:='';
    cbScriptEvent.Items.Clear;
  end;
end;

end.

