unit ScriptingUI;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Controls, Graphics, StdCtrls, Scripting;

procedure FillComboBoxWithHandlers(ComboBox: TComboBox; ScriptHandlerSet: TScriptHandlerSet);
function HandlerNameOnly(FullInfo: string): string;

implementation

procedure FillComboBoxWithHandlers(ComboBox: TComboBox; ScriptHandlerSet: TScriptHandlerSet);
var
  PrevII: Integer;

  procedure Add(Name, Info: string);
  begin
    if ScriptHandlerSet.GetHandlerCode(Name)='' then
      ComboBox.Items.Add(Name + ': ' + Info)
    else
      ComboBox.Items.Add(Name + ': (set) ' + Info);
  end;

begin
  PrevII:=ComboBox.ItemIndex;
  ComboBox.Items.Clear;
  Add(EV_CARD_VISIT, 'the user has visited a new card');
  Add(EV_CARD_LEAVE, 'the user left a card');
  Add(EV_ACTION, 'the user performed an action, like clicking a button');
  Add(EV_BUTTON_PUSH, 'the user pushed the mouse button down');
  Add(EV_BUTTON_RELEASE, 'the user released the mouse button');
  Add(EV_DOUBLE_CLICK, 'the user doubleclicked the mouse button');
  Add(EV_POINTER_HOVER, 'the mouse pointer hovered over a part');
  Add(EV_POINTER_LEAVE, 'the mouse pointer left a part');
  Add(EV_POINTER_MOTION, 'the mouse pointer moved while it was over a part');
  Add(EV_CHARACTER, 'the user has typed a character');
  Add(EV_ARROW, 'the user has pressed an arrow');
  Add(EV_KEY_PRESS, 'the user has pressed a key');
  Add(EV_KEY_RELEASE, 'the user has released a key');
  Add(EV_STACK_LOAD, 'the stack has just been loaded');
  Add(EV_STACK_SAVE, 'the stack is about to be saved');
  Add(EV_BROWSE, 'the stack entered in browse mode');
  Add(EV_TIMER, 'a timer interval has elapsed');
  ComboBox.ReadOnly:=True;
  ComboBox.Style:=csDropDownList;
  ComboBox.DropDownCount:=ComboBox.Items.Count;
  ComboBox.Sorted:=True;
  if PrevII=-1 then PrevII:=0;
  ComboBox.ItemIndex:=PrevII;
end;

function HandlerNameOnly(FullInfo: string): string;
var
  ColonPos: Integer;
begin
  ColonPos:=Pos(':', FullInfo);
  if ColonPos > 0 then Result:=Trim(Copy(FullInfo, 1, ColonPos - 1)) else Result:=Trim(FullInfo);
end;

end.

