unit ScriptErrorBoxUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TScriptErrorBox }

  TScriptErrorBox = class(TForm)
    btClear: TButton;
    lbAllIsLost: TLabel;
    mError: TMemo;
    procedure btClearClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    ShownPreviously: Boolean;
  public
    procedure ShowError(APosition: Integer; ACode, AMessage: string);
  end; 

var
  ScriptErrorBox: TScriptErrorBox;

implementation

{$R *.lfm}

{ TScriptErrorBox }

procedure TScriptErrorBox.FormShow(Sender: TObject);
var
  X, Y: Integer;
begin
  if not ShownPreviously then begin
    X:=Application.MainForm.Left + (Application.MainForm.Width - Width) div 2;
    if X < 0 then X:=0;
    Y:=Application.MainForm.Top + (Application.MainForm.Height - Height) div 2;
    if Y < 0 then Y:=0;
    Left:=X;
    Top:=Y;
    ShownPreviously:=True;
  end;
end;

procedure TScriptErrorBox.ShowError(APosition: Integer; ACode, AMessage: string);
var
  s: string;
  i: Integer;
begin
  mError.Lines.Add('Error with the following script at ' + IntToStr(APosition) + ': ' + AMessage);
  s:='';
  for i:=1 to Length(ACode) do
    if (ACode[i] in [#10, #13]) and (s <> '') then begin
      mError.Lines.Add('    ' + s);
      s:='';
    end else
      if not (ACode[i] in [#10, #13]) then s:=s + ACode[i];
  if s <> '' then mError.Lines.Add('    ' + s);
  mError.Lines.Add('');
  Show;
  BringToFront;
end;

procedure TScriptErrorBox.btClearClick(Sender: TObject);
begin
  mError.Clear;
end;

end.

