unit PartInspectorUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ComCtrls,
  StdCtrls, ExtCtrls, Cards;

type

  { TPartInspector }

  TPartInspector = class(TForm)
    cbScriptEvent: TComboBox;
    lbScriptEvent: TLabel;
    mCode: TMemo;
    PageControl1: TPageControl;
    tsProperties: TTabSheet;
    tsScripts: TTabSheet;
    procedure cbScriptEventChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure mCodeChange(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
  private
    ShownPreviously: Boolean;
    FPart: TPart;
    FPartEditor: TWinControl;
    LastScriptsSize: TPoint;
    UpdateLST: Boolean;
    procedure SetPart(const AValue: TPart);
  public
    procedure InspectPart(const APart: TPart);
    property Part: TPart read FPart write SetPart;
    property PartEditor: TWinControl read FPartEditor;
  end; 

var
  PartInspector: TPartInspector;

implementation

uses
  UIMisc, ScriptingUI;

{$R *.lfm}

{ TPartInspector }

procedure TPartInspector.FormShow(Sender: TObject);
var
  X, Y: Integer;
begin
  if not ShownPreviously then begin
    X:=Application.MainForm.Left - Width - 20;
    if X < 0 then X:=0;
    Y:=Application.MainForm.Top + (Application.MainForm.Height - Height) div 2;
    if Y < 0 then Y:=0;
    Left:=X;
    Top:=Y;
    SetupCodeFont(mCode.Font);
    LastScriptsSize.x:=Width;
    LastScriptsSize.y:=Height;
    UpdateLST:=True;
    ShownPreviously:=True;
  end;
end;

procedure TPartInspector.mCodeChange(Sender: TObject);
begin
  if Assigned(Part) then Part.ScriptHandlerSet.SetHandlerCode(HandlerNameOnly(cbScriptEvent.Text), mCode.Text);
end;

procedure TPartInspector.FormResize(Sender: TObject);
begin
  if UpdateLST and (PageControl1.ActivePage=tsScripts) then begin
    LastScriptsSize.x:=Width;
    LastScriptsSize.y:=Height;
  end;
end;

procedure TPartInspector.FormCreate(Sender: TObject);
begin
  PageControl1.ActivePage:=tsProperties;
end;

procedure TPartInspector.cbScriptEventChange(Sender: TObject);
begin
  if Assigned(Part) then mCode.Text:=Part.ScriptHandlerSet.GetHandlerCode(HandlerNameOnly(cbScriptEvent.Text));
end;

procedure TPartInspector.PageControl1Change(Sender: TObject);
begin
  if PageControl1.ActivePage=tsScripts then begin
    AutoSize:=False;
    Width:=LastScriptsSize.x;
    Height:=LastScriptsSize.y;
    UpdateLST:=True;
  end else begin
    AutoSize:=False;
    AutoSize:=True;
    UpdateLST:=False;
  end;
end;

procedure TPartInspector.SetPart(const AValue: TPart);
var
  NewPartEditor: TWinControl;
begin
  if FPart=AValue then Exit;
  FPart:=AValue;
  if Assigned(FPart) and (FPart.ID <> 0) then
    Caption:='Part &' + IntToStr(FPart.ID) + ' Inspector'
  else
    Caption:='Part Inspector';
  if Assigned(Part) then begin
    NewPartEditor:=FPart.PartEditor;
    FillComboBoxWithHandlers(cbScriptEvent, Part.ScriptHandlerSet);
    cbScriptEventChange(cbScriptEvent);
  end else begin
    NewPartEditor:=nil;
    mCode.Text:='';
    cbScriptEvent.Items.Clear;
  end;
  if PartEditor <> NewPartEditor then begin
    if Assigned(PartEditor) then begin
      PartEditor.Parent:=nil;
    end;
    FPartEditor:=NewPartEditor;
    if Assigned(PartEditor) then begin
      PartEditor.Parent:=tsProperties;
      PartEditor.Align:=alClient;
    end;
  end;
end;

procedure TPartInspector.InspectPart(const APart: TPart);
begin
  FPart:=nil; // force update
  Part:=APart;
  if not Visible then begin
    Show;
    if PageControl1.ActivePage=tsProperties then begin
      AutoSize:=False;
      AutoSize:=True;
    end;
  end;
end;

end.

