unit PaintSettingsUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Spin;

type

  { TPaintSettings }

  TPaintSettings = class(TForm)
    btExchangeColors: TButton;
    cbEnablePen: TCheckBox;
    cbEnableBrush: TCheckBox;
    cbColor: TColorButton;
    cbFill: TColorButton;
    gbPen: TGroupBox;
    gbBrush: TGroupBox;
    lbWidth: TLabel;
    lbColor: TLabel;
    lbFill: TLabel;
    seWidth: TSpinEdit;
    procedure btExchangeColorsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    ShownPreviously: Boolean;
  public
    procedure SetupCanvas(ACanvas: TCanvas);
  end; 

var
  PaintSettings: TPaintSettings;

implementation

{$R *.lfm}

{ TPaintSettings }

procedure TPaintSettings.btExchangeColorsClick(Sender: TObject);
var
  TmpColor: TColor;
begin
  TmpColor:=cbColor.ButtonColor;
  cbColor.ButtonColor:=cbFill.ButtonColor;
  cbFill.ButtonColor:=TmpColor;
end;

procedure TPaintSettings.FormCreate(Sender: TObject);
begin
  {$IFDEF DARWIN}
  gbPen.Constraints.MinWidth:=124;
  {$ENDIF}
end;

procedure TPaintSettings.FormShow(Sender: TObject);
var
  X, Y: Integer;
begin
  if not ShownPreviously then begin
    X:=Application.MainForm.Left - Width - 20;
    if X < 0 then X:=0;
    Y:=Application.MainForm.Top + 5;
    if Y < 0 then Y:=0;
    Left:=X;
    Top:=Y;
    ShownPreviously:=True;
  end;
end;

procedure TPaintSettings.SetupCanvas(ACanvas: TCanvas);
begin
  with ACanvas do begin
    if cbEnablePen.Checked then Pen.Style:=psSolid else Pen.Style:=psClear;
    Pen.Color:=cbColor.ButtonColor;
    Pen.Width:=seWidth.Value;
    Pen.Mode:=pmCopy;
    if cbEnableBrush.Checked then Brush.Style:=bsSolid else Brush.Style:=bsClear;
    Brush.Color:=cbFill.ButtonColor;
  end;
end;

end.

