#!/bin/bash

rm -fr LILCard.app
rm -fr lilcard.app
rm -fr lilcard
rm -fr dmgsrc
rm -fr LILCard.dmg

lazbuild -B -r --os=darwin --ws=carbon --cpu=i386 --bm=Release lilcard.lpr

if [ ! -e lilcard.app/Contents/MacOS/lilcard ]
then
    echo Failed
    exit
fi

mkdir dmgsrc
mkdir dmgsrc/LILCard.app
mkdir dmgsrc/LILCard.app/Contents
mkdir dmgsrc/LILCard.app/Contents/MacOS
mkdir dmgsrc/LILCard.app/Contents/Resources
cp infoplist.txt dmgsrc/LILCard.app/Contents/Info.plist
cp lilcard.app/Contents/PkgInfo dmgsrc/LILCard.app/Contents
cp lilcard dmgsrc/LILCard.app/Contents/MacOS
strip dmgsrc/LILCard.app/Contents/MacOS/lilcard
hdiutil create LILCard.dmg -srcfolder dmgsrc -ov -volname "LILCard" -format UDBZ
echo DONE

