unit FieldPartEditorUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, StdCtrls, Dialogs, Cards;

type

  { TFieldPartEditor }

  TFieldPartEditor = class(TFrame)
    cbColor: TColorButton;
    cbBorderColor: TColorButton;
    cbDrawBorder: TCheckBox;
    cbReadOnly: TCheckBox;
    cbWordWrapping: TCheckBox;
    cbShared: TCheckBox;
    cbVisible: TCheckBox;
    edName: TEdit;
    lbColor: TLabel;
    lbBorderColor: TLabel;
    lbName: TLabel;
    procedure cbBorderColorColorChanged(Sender: TObject);
    procedure cbColorColorChanged(Sender: TObject);
    procedure cbDrawBorderChange(Sender: TObject);
    procedure cbReadOnlyChange(Sender: TObject);
    procedure cbSharedChange(Sender: TObject);
    procedure cbVisibleChange(Sender: TObject);
    procedure cbWordWrappingChange(Sender: TObject);
    procedure edNameChange(Sender: TObject);
  private
    FPart: TFieldPart;
    procedure SetPart(const AValue: TFieldPart);
    procedure UpdateValuesFromPart;
  public
    property Part: TFieldPart read FPart write SetPart;
  end;

function GetFieldPartEditor: TFieldPartEditor;

implementation

var
  FieldPartEditor: TFieldPartEditor;

function GetFieldPartEditor: TFieldPartEditor;
begin
  if not Assigned(FieldPartEditor) then begin
    FieldPartEditor:=TFieldPartEditor.Create(Application.MainForm);
  end;
  Result:=FieldPartEditor;
end;

{$R *.lfm}

{ TFieldPartEditor }

procedure TFieldPartEditor.edNameChange(Sender: TObject);
begin
  if Assigned(Part) then Part.Name:=edName.Text;
end;

procedure TFieldPartEditor.cbDrawBorderChange(Sender: TObject);
begin
  if Assigned(Part) then Part.Border:=cbDrawBorder.Checked;
end;

procedure TFieldPartEditor.cbColorColorChanged(Sender: TObject);
begin
  if Assigned(Part) then Part.Color:=cbColor.ButtonColor;
end;

procedure TFieldPartEditor.cbBorderColorColorChanged(Sender: TObject);
begin
  if Assigned(Part) then Part.BorderColor:=cbBorderColor.ButtonColor;
end;

procedure TFieldPartEditor.cbReadOnlyChange(Sender: TObject);
begin
  if Assigned(Part) then Part.ReadOnly:=cbReadOnly.Checked;
end;

procedure TFieldPartEditor.cbSharedChange(Sender: TObject);
begin
  if Assigned(Part) then Part.SharedData:=cbShared.Checked;
end;

procedure TFieldPartEditor.cbVisibleChange(Sender: TObject);
begin
  if Assigned(Part) then Part.Visible:=cbVisible.Checked;
end;

procedure TFieldPartEditor.cbWordWrappingChange(Sender: TObject);
begin
  if Assigned(Part) then Part.WordWrap:=cbWordWrapping.Checked;
end;

procedure TFieldPartEditor.SetPart(const AValue: TFieldPart);
begin
  FPart:=AValue;
  UpdateValuesFromPart;
end;

procedure TFieldPartEditor.UpdateValuesFromPart;
begin
  edName.Text:=Part.Name;
  cbDrawBorder.Checked:=Part.Border;
  cbReadOnly.Checked:=Part.ReadOnly;
  cbWordWrapping.Checked:=Part.WordWrap;
  cbShared.Checked:=Part.SharedData;
  cbShared.Enabled:=Assigned(Part.Card) and not Assigned(Part.Card.Background);
  cbVisible.Checked:=Part.Visible;
  cbColor.ButtonColor:=Part.Color;
  cbBorderColor.ButtonColor:=Part.BorderColor;
end;

end.

