import os, glob, csv, string

lilfuncs = list()
lilfdict = dict()

def lhescape(s):
    r = ''
    s = s.strip()
    for i in xrange(0, len(s)):
        if s[i] in ['\\', '{', '}', '[', ']', '/']:
            r = r + '/'
        elif s[i] == '\n':
            r = r + '\\p{}'
        if s[i] != '\r' and s[i] != '\n':
            r = r + s[i]
    return r

def func_prettyname(s):
    r = ''
    for i in xrange(0, len(s)):
        if s[i] in ['[', '<', '(']:
            break
        r = r + s[i]
    r = r.strip()
    return r

def codeforfunc(f):
    code = '\\page[scriptcmdref' + f['name'] + ']{\\title[Command Reference]\\h[1]{' + lhescape(f['prettyname']) + '}\\p{\\b{Synopsis:} ' + lhescape(f['brief']) + '}'

    code = code + '\\p{\\b{Syntax:} ' + lhescape(f['syntax']) + '}'
    code = code + '\\p{\\b{Description:} ' + lhescape(f['desc']) + '}'
    code = code + '\\p{\\b{Example:}}\\p{' + lhescape(f['example']) + '}'
    if len(f['seealso']) > 0:
        code = code + '\\p{\\b{See Also: }'
        first = True
        for sa in f['seealso']:
            saf = lilfdict[sa]
            if not first:
                code = code + ', '
            first = False
            code = code + '\\a[scriptcmdref' + sa + ']{' + lhescape(saf['prettyname']) + '}'
        code = code + '}'
    code = code + '}'
    return code

def load_lildoc_csv(csvfilename):
    global lilfuncs
    with open(csvfilename, 'rb') as fh:
        reader = csv.DictReader(fh)
        for row in reader:
            row['prettyname'] = func_prettyname(row['syntax'])
            row['seealso'] = string.split(row['seealso'])
            lilfuncs.append(row)
            lilfdict[row['name']] = row

load_lildoc_csv('lilfuncs.csv')
load_lildoc_csv('lcfuncs.csv')
lilfuncs.sort(key=lambda func: func['name'])

code = ''

for f in glob.glob('*.lazhelp'):
    if f == 'lilcard.lazhelp':
        continue
    with open(f, 'rb') as fh:
        code = code + fh.read() + '\r\n'

code = code + '\\page[scriptcmdref]{\\title[Command Reference]\\h[1]{Command Reference}\\p{Below are all the LIL functions available for use with LILCard. For details on the LIL language see the \\a[scriptguide]{scripting guide} and the \\a[lildocumentationurl]{LIL documentation}.}\\ul{'
for func in lilfuncs:
    code = code + '\\li{\\a[scriptcmdref' + func['name'] + ']{' + lhescape(func['prettyname']) + '} - ' + lhescape(func['brief']) + '}'
code = code + '\\}}'

for func in lilfuncs:
    code = code + codeforfunc(func) + '\r\n'

with open('lilcard.lazhelp', 'wb') as fh:
    fh.write(code)

with open('lilcardhelp.inc', 'wb') as fh:
    fh.write('LazHelp1.Code:=')
    ctr = 0
    for i in xrange(0, len(code)):
        ctr = ctr + 1
        if ctr == 10:
            fh.write(' + \r\n')
            ctr = 0
        fh.write('#' + str(ord(code[i])))
    fh.write(';\r\n')

