unit CommanderUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TCommander }

  TCommander = class(TForm)
    edCmd: TEdit;
    procedure edCmdKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure edCmdKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
  private
    ShownPreviously: Boolean;
  public
    procedure Put(Str: string);
    procedure DoCommand(Cmd: string);
  end; 

var
  Commander: TCommander;

implementation

uses
  Scripting;

{$R *.lfm}

{ TCommander }

procedure TCommander.FormShow(Sender: TObject);
var
  X, Y: Integer;
begin
  if not ShownPreviously then begin
    X:=Application.MainForm.Left;
    if X > Screen.Width - Width - 20 then X:=Screen.Width - Width - 20;
    Y:=Application.MainForm.Top + Application.MainForm.Height + 40;
    if Y > Screen.DesktopHeight - Height - 30 then Y:=Screen.DesktopHeight - Height - 30;
    Left:=X;
    Top:=Y;
    ClientWidth:=Application.MainForm.ClientWidth;
    ShownPreviously:=True;
  end;
  ClientHeight:=edCmd.Height;
end;

procedure TCommander.Put(Str: string);
begin
  if Str=#10 then Exit;
  edCmd.Text:=Str;
  edCmd.SelStart:=Length(Str);
  edCmd.SelLength:=0;
  try
    Show;
    BringToFront;
    edCmd.SetFocus;
  except
  end;
end;

procedure TCommander.DoCommand(Cmd: string);
begin
  Cmd:=Trim(Cmd);
  edCmd.Text:='';
  if Cmd='' then Exit;
  EvaluateScriptCode(Cmd);
end;

procedure TCommander.edCmdKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key in [10, 13] then begin
    DoCommand(edCmd.Text);
    Key:=0;
  end;
end;

procedure TCommander.edCmdKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key in [10, 13] then Key:=0;
end;

end.

