unit CardInspectorUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Cards;

type

  { TCardInspector }

  TCardInspector = class(TForm)
    cbScriptEvent: TComboBox;
    edName: TEdit;
    lbName: TLabel;
    lbScript: TLabel;
    mCode: TMemo;
    procedure cbScriptEventChange(Sender: TObject);
    procedure edNameChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure mCodeChange(Sender: TObject);
  private
    FCard: TCard;
    ShownPreviously: Boolean;
    procedure SetCard(const AValue: TCard);
  public
    procedure InspectCard(ACard: TCard);
    property Card: TCard read FCard write SetCard;
  end; 

var
  CardInspector: TCardInspector;

implementation

uses
  UIMisc, ScriptingUI;

{$R *.lfm}

{ TCardInspector }

procedure TCardInspector.FormShow(Sender: TObject);
var
  X, Y: Integer;
begin
  if not ShownPreviously then begin
    X:=Application.MainForm.Left + Application.MainForm.Width + 20;
    if X > Screen.Width - Width - 20 then X:=Screen.Width - Width - 20;
    Y:=Application.MainForm.Top + (Application.MainForm.Height div 2 - Height - 20);
    if Y < 0 then Y:=0;
    Left:=X;
    Top:=Y;
    SetupCodeFont(mCode.Font);
    ShownPreviously:=True;
  end;
end;

procedure TCardInspector.mCodeChange(Sender: TObject);
begin
  if Assigned(Card) then Card.ScriptHandlerSet.SetHandlerCode(HandlerNameOnly(cbScriptEvent.Text), mCode.Text);
end;

procedure TCardInspector.edNameChange(Sender: TObject);
begin
  if Assigned(Card) then Card.Name:=edName.Text;
end;

procedure TCardInspector.cbScriptEventChange(Sender: TObject);
begin
  if Assigned(Card) then mCode.Text:=Card.ScriptHandlerSet.GetHandlerCode(HandlerNameOnly(cbScriptEvent.Text));
end;

procedure TCardInspector.SetCard(const AValue: TCard);
begin
  FCard:=AValue;
  if Assigned(Card) then begin
    edName.Text:=Card.Name;
    FillComboBoxWithHandlers(cbScriptEvent, Card.ScriptHandlerSet);
    cbScriptEventChange(cbScriptEvent);
    if Card.ID <> 0 then
      Caption:='Card &' + IntToStr(Card.ID) + ' inspector'
    else
      Caption:='Card Inspector';
  end else begin
    mCode.Text:='';
    edName.Text:='';
    cbScriptEvent.Items.Clear;
    Caption:='Card Inspector';
  end;
end;

procedure TCardInspector.InspectCard(ACard: TCard);
begin
  Card:=ACard;
  if not Visible then Show;
end;

end.

