unit ButtonPartEditorUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, StdCtrls, Dialogs, ExtCtrls,
  ExtDlgs, Cards, Graphics;

type

  { TButtonPartEditor }

  TButtonPartEditor = class(TFrame)
    btLoad: TButton;
    btClear: TButton;
    btFitSize: TButton;
    cbAutoHighlight: TCheckBox;
    cbDrawName: TCheckBox;
    cbColor: TColorButton;
    cbVisible: TCheckBox;
    cbInteractive: TCheckBox;
    edName: TEdit;
    gbImage: TGroupBox;
    imImage: TImage;
    lbColor: TLabel;
    lbName: TLabel;
    OpenPictureDialog1: TOpenPictureDialog;
    plImage: TPanel;
    rgStyle: TRadioGroup;
    procedure btClearClick(Sender: TObject);
    procedure btFitSizeClick(Sender: TObject);
    procedure btLoadClick(Sender: TObject);
    procedure cbAutoHighlightChange(Sender: TObject);
    procedure cbColorColorChanged(Sender: TObject);
    procedure cbDrawNameChange(Sender: TObject);
    procedure cbInteractiveChange(Sender: TObject);
    procedure cbVisibleChange(Sender: TObject);
    procedure edNameChange(Sender: TObject);
    procedure rgStyleSelectionChanged(Sender: TObject);
  private
    FPart: TButtonPart;
    procedure SetPart(const AValue: TButtonPart);
    procedure UpdateValuesFromPart;
  public
    property Part: TButtonPart read FPart write SetPart;
  end;

function GetButtonPartEditor: TButtonPartEditor;

implementation

var
  ButtonPartEditor: TButtonPartEditor;

function GetButtonPartEditor: TButtonPartEditor;
begin
  if not Assigned(ButtonPartEditor) then begin
    ButtonPartEditor:=TButtonPartEditor.Create(Application.MainForm);
  end;
  Result:=ButtonPartEditor;
end;

{$R *.lfm}

{ TButtonPartEditor }

procedure TButtonPartEditor.edNameChange(Sender: TObject);
begin
  if Assigned(Part) then Part.Name:=edName.Text;
end;

procedure TButtonPartEditor.rgStyleSelectionChanged(Sender: TObject);
begin
  if Assigned(Part) then Part.Style:=TButtonPartStyle(rgStyle.ItemIndex);
end;

procedure TButtonPartEditor.cbAutoHighlightChange(Sender: TObject);
begin
  if Assigned(Part) then Part.AutoHighlight:=cbAutoHighlight.Checked;
end;

procedure TButtonPartEditor.btLoadClick(Sender: TObject);
var
  Pic: TPicture;
begin
  if Assigned(Part) and OpenPictureDialog1.Execute then begin
    Pic:=TPicture.Create;
    try
      Pic.LoadFromFile(OpenPictureDialog1.FileName);
      if Assigned(Part.Image) then Part.Image.Free;
      Part.Image:=TBitmap.Create;
      Part.Image.Assign(Pic.Bitmap);
      imImage.Picture.Assign(Pic);
      imImage.Repaint;
    except
      MessageDlg('Load Image', 'Failed to load ' + OpenPictureDialog1.FileName, mtError, [mbOK], 0);
    end;
    FreeAndNil(Pic);
  end;
end;

procedure TButtonPartEditor.btClearClick(Sender: TObject);
begin
  if Assigned(Part.Image) then Part.Image.Free;
  Part.Image:=nil;
  imImage.Picture.Clear;
end;

procedure TButtonPartEditor.btFitSizeClick(Sender: TObject);
begin
  if Assigned(Part) and Assigned(Part.Image) then begin
    if Part.Style=bpsInvisible then begin
      Part.X2:=Part.Image.Width + Part.X1;
      Part.Y2:=Part.Image.Height + Part.Y1;
    end else begin
      Part.X2:=Part.Image.Width + Part.X1 + 4;
      Part.Y2:=Part.Image.Height + Part.Y1 + 4;
    end;
  end;
end;

procedure TButtonPartEditor.cbColorColorChanged(Sender: TObject);
begin
  if Assigned(Part) then Part.Color:=cbColor.ButtonColor;
end;

procedure TButtonPartEditor.cbDrawNameChange(Sender: TObject);
begin
  if Assigned(Part) then Part.DrawName:=cbDrawName.Checked;
end;

procedure TButtonPartEditor.cbInteractiveChange(Sender: TObject);
begin
  if Assigned(Part) then Part.Interactive:=cbInteractive.Checked;
end;

procedure TButtonPartEditor.cbVisibleChange(Sender: TObject);
begin
  if Assigned(Part) then Part.Visible:=cbVisible.Checked;
end;

procedure TButtonPartEditor.SetPart(const AValue: TButtonPart);
begin
  FPart:=AValue;
  UpdateValuesFromPart;
end;

procedure TButtonPartEditor.UpdateValuesFromPart;
begin
  edName.Text:=Part.Name;
  cbAutoHighlight.Checked:=Part.AutoHighlight;
  cbDrawName.Checked:=Part.DrawName;
  cbVisible.Checked:=Part.Visible;
  cbInteractive.Checked:=Part.Interactive;
  cbColor.ButtonColor:=Part.Color;
  rgStyle.ItemIndex:=Integer(Part.Style);
  if Assigned(Part.Image) then
    imImage.Picture.Assign(Part.Image)
  else
    imImage.Picture.Clear
end;

end.

