unit AboutBoxUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls;

type

  { TAboutBox }

  TAboutBox = class(TForm)
    btClose: TButton;
    imLogo: TImage;
    lbVersion: TLabel;
    lbURL: TLabel;
    procedure lbURLClick(Sender: TObject);
    procedure lbURLMouseEnter(Sender: TObject);
    procedure lbURLMouseLeave(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  AboutBox: TAboutBox;

procedure ShowAboutBox;

implementation

uses
  LCLIntf;

procedure ShowAboutBox;
begin
  Application.CreateForm(TAboutBox, AboutBox);
  AboutBox.ShowModal;
  FreeAndNil(AboutBox);
end;

{ TAboutBox }

procedure TAboutBox.lbURLMouseEnter(Sender: TObject);
begin
  lbURL.Font.Color:=clRed;
end;

procedure TAboutBox.lbURLClick(Sender: TObject);
begin
  OpenURL(lbURL.Caption);
end;

procedure TAboutBox.lbURLMouseLeave(Sender: TObject);
begin
  lbURL.Font.Color:=clLime;
end;

{$R *.lfm}

end.

