#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>

static int paint_handler(void* sep, ff_event_t* ev, void* data)
{
    ff_gc_t gc = ev->p;
    int w, h, orientation;
    if (!strcmp(ff_get(sep, "orientation"), "vertical"))
        orientation = 1;
    else
        orientation = 0;
    ff_area(sep, NULL, NULL, &w, &h);
    ff_color_attr(gc, sep, "background", FF_3DFACE_COLOR);
    ff_fill(gc, 0, 0, w, h);

    switch (orientation) {
    case 0: /* horizontal */
        ff_color(gc, FF_3DSHADOW_COLOR);
        ff_line(gc, 0, h/2 - 1, w, h/2 - 1);
        ff_color(gc, FF_3DLIGHT_COLOR);
        ff_line(gc, 0, h/2, w, h/2);
        break;
    case 1:
        ff_color(gc, FF_3DSHADOW_COLOR);
        ff_line(gc, w/2 - 1, 0, w/2 - 1, h);
        ff_color(gc, FF_3DLIGHT_COLOR);
        ff_line(gc, w/2, 0, w/2, h);
        break;
    }
    return 1;
}

ff_window_t ff_separator(ff_window_t parent, const char* orientation)
{
    ff_window_t sep = ff_window(parent, 0, 0, 2, 2, FF_NOFLAGS);
    ff_set(sep, "class", (void*)"separator");
    ff_set(sep, "orientation", (void*)(orientation ? orientation : "horizontal"));
    ff_link(sep, FF_PAINT, paint_handler, NULL);
    ff_prefsize(sep, 2, 2);
    return sep;
}

