#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>

typedef struct postinfo {
    struct _obj_t* obj;
    unsigned event;
    int x, y, z;
    unsigned flags;
    void* p;
} postinfo_t;

typedef struct _link_t
{
    unsigned event;
    ff_handler_proc_t handler;
    void* data;
} link_t;

typedef struct _attr_t
{
    char* name;
    void* value;
} attr_t;

typedef struct _obj_t
{
    ff_destructor_proc_t dtor;
    void* sup;
    link_t* link;
    size_t links;
    attr_t* attr;
    size_t attrs;
} obj_t;

#ifdef OREAL
#undef OREAL
#endif
#ifdef OVIRT
#undef OVIRT
#endif

#define OREAL(o) ((o) ? ((obj_t*)(((char*)(o)) - sizeof(obj_t))) : NULL)
#define OVIRT(o) ((o) ? ((void*)(((char*)(o)) + sizeof(obj_t))) : NULL)

static postinfo_t** post;
static size_t posts;
static link_t* glink;
static size_t glinks;

static void invalidate_postinfo_object(void* obj)
{
    size_t i;
    if (!posts) return;
    i = posts - 1;
    for (;;i--) {
        if (post[i]->obj == obj)
            post[i]->obj = NULL;
        if (!i) break;
    }
}

void* ff_new(size_t size)
{
    char* objdata = calloc(1, sizeof(obj_t) + size);
    return objdata + sizeof(obj_t);
}

void ff_destructor(void* obj_, ff_destructor_proc_t proc)
{
    obj_t* const obj = OREAL(obj_);
    if (obj) obj->dtor = proc;
}

void ff_destroy(void* obj_)
{
    obj_t* const obj = OREAL(obj_);
    size_t i;
    if (!obj_) return;
    if (obj->dtor) if (!obj->dtor(obj_)) return;
    ff_send(obj_, FF_DESTROY, 0, 0, 0, NULL, FF_NOFLAGS);
    free(obj->link);
    for (i=0; i < obj->attrs; i++) free(obj->attr[i].name);
    free(obj->attr);
    free(obj);
    invalidate_postinfo_object(obj_);
}

void ff_superior(void* obj_, void* sup)
{
    obj_t* const obj = OREAL(obj_);
    if (obj_) obj->sup = sup;
}

void ff_link(void* obj_, unsigned event, ff_handler_proc_t handler, void* data)
{
    obj_t* const obj = OREAL(obj_);
    if (obj_) {
        obj->link = realloc(obj->link, sizeof(link_t)*(obj->links + 1));
        obj->link[obj->links].event = event;
        obj->link[obj->links].handler = handler;
        obj->link[obj->links].data = data;
        obj->links++;
    } else {
        glink = realloc(glink, sizeof(link_t)*(glinks + 1));
        glink[glinks].event = event;
        glink[glinks].handler = handler;
        glink[glinks].data = data;
        glinks++;
    }
}

void ff_unlink(void* obj_, unsigned event, ff_handler_proc_t handler)
{
    obj_t* const obj = OREAL(obj_);
    size_t i, index;
    if (obj) {
        for (i=0; i < obj->links; i++)
            if (obj->link[i].event == event &&
                obj->link[i].handler == handler)
            {
                index = i;
                break;
            }
        if (i == obj->links) return;
        obj->links--;
        for (i=index; i < obj->links; i++)
            obj->link[i] = obj->link[i + 1];
    } else {
        for (i=0; i < glinks; i++)
            if (glink[i].event == event &&
                glink[i].handler == handler)
            {
                index = i;
                break;
            }
        if (i == glinks) return;
        glinks--;
        for (i=index; i < glinks; i++)
            glink[i] = glink[i + 1];
    }
}

int ff_send(void* obj_, unsigned event, int x, int y, int z, void* p, unsigned flags)
{
    obj_t* obj = OREAL(obj_);
    size_t i;
    ff_event_t ev;
    memset(&ev, 0, sizeof(ff_event_t));
    ev.dest = obj_;
    ev.event = event;
    ev.x = x;
    ev.y = y;
    ev.z = z;
    ev.p = p;
    if (obj_) {
        while (obj_) {
            if (obj->links) {
                i = obj->links - 1;
                for (;;i--) {
                    if (obj->link[i].event == event &&
                        obj->link[i].handler(obj_, &ev, obj->link[i].data))
                        return 1;
                    if (!i) break;
                }
            }
            if (!(flags & FF_BUBBLE)) break;
            if (ff_send(obj_, FF_BUBBLEMASK, 0, 0, 0, &ev, FF_NOFLAGS)) break;
            obj_ = obj->sup;
            obj = OREAL(obj_);
        }
        if (!(flags & FF_BUBBLE)) return 0;
    }
    if (glinks) {
        i = glinks - 1;
        for (;;i--) {
            if (glink[i].event == event && glink[i].handler(NULL, &ev, glink[i].data))
                return 1;
            if (!i) break;
        }
    }
    return 0;
}

int ff_forward(void* obj_, ff_event_t* ev)
{
    obj_t* const obj = OREAL(obj_);
    size_t i;
    if (!ev) return 0;
    if (obj_) {
        if (obj->links) {
            i = obj->links - 1;
            for (;;i--) {
                if (obj->link[i].event == ev->event && obj->link[i].handler(obj_, ev, obj->link[i].data))
                    return 1;
                if (!i) break;
            }
        }
    } else {
        if (glinks) {
            i = glinks - 1;
            for (;;i--) {
                if (glink[i].event == ev->event && glink[i].handler(NULL, ev, glink[i].data))
                    return 1;
                if (!i) break;
            }
        }
    }
    return 0;
}

int ff_redirect(void* obj, ff_event_t* ev, void* data)
{
    return ff_forward(data, ev);
}

static void do_post(postinfo_t* info)
{
    size_t i, j;
    ff_send(info->obj, info->event, info->x, info->y, info->z, info->p, info->flags);
    for (i=0; i < posts; i++)
        if (post[i] == info) {
            posts--;
            for (j=i; j < posts; j++)
                post[j] = post[j + 1];
        }
    free(info);
}

void ff_post(void* obj, unsigned event, int x, int y, int z, void* p, unsigned flags)
{
    postinfo_t* info = malloc(sizeof(postinfo_t));
    info->obj = obj;
    info->event = event;
    info->x = x;
    info->y = y;
    info->z = z;
    info->flags = flags;
    info->p = p;
    ff_later((ff_later_proc_t)do_post, info);
    post = realloc(post, sizeof(postinfo_t*)*(posts + 1));
    post[posts++] = info;
}

void ff_set(void* obj_, const char* name, void* value)
{
    obj_t* const obj = OREAL(obj_);
    ff_namevalue_t nv;
    size_t i;
    nv.name = name;
    nv.value = value;
#ifdef DUMP_SET
    printf("set object=%p (real: %p) name='%s' value=%p (as int=%i)\n",
        obj_, obj, name, value, (int)ff_toint(value));
#endif
    if (name[0] != '-' && ff_send(obj_, FF_SET, 0, 0, 0, &nv, FF_NOFLAGS))
        return;
    for (i=0; i<obj->attrs; i++)
        if (!strcmp(name, obj->attr[i].name)) {
            obj->attr[i].value = value;
            return;
        }
    obj->attr = realloc(obj->attr, sizeof(attr_t)*(obj->attrs + 1));
    obj->attr[obj->attrs].name = ff_strdup(name);
    obj->attr[obj->attrs].value = value;
    obj->attrs++;
}

static int do_get(void* obj_, const char* name, void** value)
{
    obj_t* const obj = OREAL(obj_);
    ff_namevalue_t nv;
    size_t i;
    int r = FF_NO;
    if (!obj) return FF_NO;
    *value = NULL;
    nv.name = name;
    nv.value = NULL;
    for (i=0; i<obj->attrs; i++)
        if (!strcmp(name, obj->attr[i].name)) {
            nv.value = *value = obj->attr[i].value;
            r = FF_YES;
            break;
        }
    if (name[0] != '-' && ff_send(obj_, FF_GET, 0, 0, 0, &nv, FF_NOFLAGS)) {
        *value = nv.value;
        r = FF_YES;
    }
    return r;
}

void* ff_get(void* obj, const char* name)
{
    void* value;
    do_get(obj, name, &value);
    return value;
}

void ff_seti(void* obj, const char* name, int i)
{
    union {
        ff_intptr_t i;
        void* p;
    } v;
    v.p = NULL;
    v.i = i;
    ff_set(obj, name, v.p);
}

void ff_setu(void* obj, const char* name, unsigned u)
{
    union {
        ff_uintptr_t u;
        void* p;
    } v;
    v.p = NULL;
    v.u = u;
    ff_set(obj, name, v.p);
}

void ff_setcs(void* obj, const char* name, const char* value)
{
    union {
        const char* s;
        void* p;
    } v;
    v.s = value;
    ff_set(obj, name, v.p);
}

int ff_geti(void* obj, const char* name)
{
    union {
        ff_intptr_t i;
        void* p;
    } v;
    v.i = 0;
    v.p = ff_get(obj, name);
    return (int)v.i;
}

int ff_geti_def(void* obj, const char* name, int def)
{
    union {
        ff_intptr_t i;
        void* p;
    } v;
    v.i = 0;
    if (do_get(obj, name, &v.p)) return (int)v.i;
    return def;
}

int ff_get_or_fail(void* obj, const char* name, void** value)
{
    return do_get(obj, name, value);
}

int ff_geti_or_fail(void* obj, const char* name, int* value)
{
    union {
        ff_intptr_t i;
        void* p;
    } v;
    v.i = 0;
    if (do_get(obj, name, &v.p)) {
        *value = (int)v.i;
        return FF_YES;
    }
    return FF_NO;
}

unsigned ff_getu(void* obj, const char* name)
{
    union {
        ff_uintptr_t i;
        void* p;
    } v;
    v.i = 0;
    if (do_get(obj, name, &v.p)) return (unsigned)v.i;
    return 0;
}

unsigned ff_getu_def(void* obj, const char* name, unsigned def)
{
    union {
        ff_uintptr_t i;
        void* p;
    } v;
    v.i = 0;
    if (do_get(obj, name, &v.p)) return (unsigned)v.i;
    return def;
}

int ff_getu_or_fail(void* obj, const char* name, unsigned* value)
{
    union {
        ff_uintptr_t i;
        void* p;
    } v;
    v.i = 0;
    if (do_get(obj, name, &v.p)) {
        *value = (unsigned)v.i;
        return FF_YES;
    }
    return FF_NO;
}
