#define LFORMS_SOURCE_CODE
#include <lforms.h>

static void notebook_update(ff_window_t nb, int selection)
{
    ff_window_t* children = ff_children(nb);
    int i;
    for (i=0; children[i]; i++) {
        int page = ff_geti_def(children[i], "notebook-page", -1);
        ff_show(children[i], page == -1 || page == selection);
    }
    ff_free_children(children);
}

static int set_handler(void* nb, ff_event_t* ev, void* data)
{
    ff_namevalue_t* nv = ev->p;
    if (!strcmp(nv->name, "selection")) {
        if (ff_geti(nb, "selection") < 0) return FF_YES;
        if ((int)(ff_intptr_t)nv->value != ff_geti(nb, "selection")) {
            ff_window_t selector = ff_get(nb, "selector");
            if (selector) ff_set(selector, "selection", nv->value);
            notebook_update(nb, (int)(ff_intptr_t)nv->value);
        }
    }
    return FF_NO;
}

static int child_handler(void* nb, ff_event_t* ev, void* data)
{
    if (ev->x == FF_ADD) {
        int page;
        if (!ff_geti_or_fail(ev->p, "notebook-page", &page))
            ff_seti(ev->p, "notebook-page", ff_geti(nb, "selection"));
        else
            notebook_update(nb, ff_geti(nb, "selection"));
    }
    return FF_NO;
}

static int selector_select(void* ts, ff_event_t* ev, void* nb)
{
    void* selector = ff_get(nb, "selector");
    ff_set(nb, "selector", NULL);
    ff_seti(nb, "selection", ev->x);
    ff_set(nb, "selector", selector);
    return FF_YES;
}

ff_window_t ff_notebook(ff_window_t parent, ff_window_t selector)
{
    ff_window_t nb = ff_window(parent, 0, 0, 200, 125, FF_NOFLAGS);
    ff_set(nb, "class", (void*)"notebook");
    ff_seti(nb, "selection", 0);
    ff_link(nb, FF_SET, set_handler, NULL);
    ff_link(nb, FF_CHILD, child_handler, NULL);
    if (selector) {
        ff_set(nb, "selector", selector);
        ff_link(selector, FF_SELECT, selector_select, nb);
    }
    return nb;
}

void ff_notebook_update(ff_window_t nb)
{
    notebook_update(nb, ff_geti(nb, "selection"));
}
