#define LFORMS_SOURCE_CODE
#if defined(__unix) || defined(__unix__)
#define _XOPEN_SOURCE 500
#endif
#include <stdlib.h>
#include <lforms.h>
#include <lforms/winsys.h>

typedef void (*aeproc_t)(void);

static int app_argc;
static char** app_argv;
static const char* application_name;
static int running;
static int run_exitcode;
static aeproc_t* aeproc;
static size_t aeprocs;
static ff_later_proc_t* later;
static void** laterdata;
static int laters;

static void process_events(int sync, int wait)
{
    do {
        ff_ws_process_laters();
        if (sync) ff_ws_sync();
        if (wait || ff_has_events()) {
            if (!ff_ws_pump_events())
                running = FF_NO;
            ff_ws_process_laters();
        }
    } while (ff_has_events());
}

int ff_init(int argc, char** argv, const char* appname)
{
    int i;
    app_argc = argc;
    app_argv = malloc(sizeof(char*)*(size_t)argc);
    for (i=0; i < argc; i++) app_argv[i] = ff_strdup(argv[i]);
#if defined(__unix) || defined(__unix__)
    if (argc > 0) {
        char* full = realpath(argv[0], NULL);
        free(app_argv[0]);
        app_argv[0] = full;
    }
#endif
    application_name = appname;
    running = FF_YES;
    if (!ff_ws_init(argc, argv))
        return 0;
    return 1;
}

void ff_exit(int exitcode)
{
    ff_ws_exit(exitcode);
    running = FF_NO;
    run_exitcode = exitcode;
}

int ff_run(void)
{
    int i;
    while (running)
        process_events(FF_NO, FF_YES);
    process_events(FF_YES, FF_NO);
    while (aeprocs) {
        aeprocs--;
        aeproc[aeprocs]();
    }
    free(aeproc);
    ff_ws_shutdown();
    for (i=0; i < app_argc; i++) free(app_argv[i]);
    free(app_argv);
    return run_exitcode;
}

int ff_running(void)
{
    return running;
}

void ff_ws_process_laters(void)
{
    static int depth;
    static int pos;
    if (!depth) pos = 0;
    depth++;
    while (pos < laters) {
        pos++;
        later[pos - 1](laterdata[pos - 1]);
    }
    depth--;
    if (pos >= laters) {
        free(laterdata);
        free(later);
        later = NULL;
        laterdata = NULL;
        laters = 0;
    }
}

void ff_pump_events(void)
{
    process_events(FF_YES, FF_NO);
}

int ff_has_events(void)
{
    return laters || ff_ws_has_events();
}

void ff_atexit(void(*proc)(void))
{
    aeproc = realloc(aeproc, sizeof(aeproc_t)*(aeprocs + 1U));
    aeproc[aeprocs++] = proc;
}

void ff_later(ff_later_proc_t proc, void* data)
{
    later = realloc(later, sizeof(ff_later_proc_t)*(size_t)(laters + 1));
    laterdata = realloc(laterdata, sizeof(void*)*(size_t)(laters + 1));
    later[laters] = proc;
    laterdata[laters] = data;
    laters++;
}

int ff_argc(void)
{
    return app_argc;
}

char** ff_argv(void)
{
    return app_argv;
}

const char* ff_appname(void)
{
    return application_name;
}
