#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>

typedef struct _cell_t
{
    ff_window_t win;
    int pw, ph;
    unsigned cspan:15, rspan:15;
    unsigned spanned:1;
} cell_t;

void ff_grid(ff_window_t win, ff_window_t* child, int children, int width, int height)
{
    int x, y, i, j, cx, cy, cw, ch, colspan, rowspan, rows, allw, allh;
    int samewidth, sameheight;
    float xscale, yscale;
    cell_t* cell;
    int* colw;
    int* rowh;
    const char* autosize;
    int cols;
    if (!children) return;
    autosize = ff_get(win, "grid-autosize");
    samewidth = autosize && (!strcmp(autosize, "same-width") || !strcmp(autosize, "same-size"));
    sameheight = autosize && (!strcmp(autosize, "same-height") || !strcmp(autosize, "same-size"));
    cols = ff_geti_def(win, "grid-columns", 2);
    for (i=j=0; i < children; i++) {
        colspan = ff_geti_def(child[i], "grid-column-span", 1);
        rowspan = ff_geti_def(child[i], "grid-row-span", 1);
        if (colspan < 1) colspan = 1;
        if (rowspan < 1) rowspan = 1;
        j += colspan*rowspan;
    }
    rows = j/cols + (j%cols > 0 ? 1 : 0);
    cell = calloc(1, sizeof(cell_t)*(size_t)(cols*rows));
    colw = malloc(sizeof(int)*(size_t)cols);
    rowh = malloc(sizeof(int)*(size_t)rows);
    for (y=0; y < rows; y++)
        for (x=0; x < cols; x++) {
            if (y*cols + x >= children) break;
            colspan = ff_geti_def(child[y*cols + x], "grid-column-span", 1);
            rowspan = ff_geti_def(child[y*cols + x], "grid-row-span", 1);
            if (colspan < 1) colspan = 1;
            if (rowspan < 1) rowspan = 1;
            if (x + colspan > cols) colspan = cols - x;
            if (y + rowspan > rows) rowspan = rows - y;
            if (colspan < 2 && rowspan < 2) continue;
            cell[y*cols + x].win = child[y*cols + x];
            cell[y*cols + x].cspan = (unsigned)colspan&0x7FFF;
            cell[y*cols + x].rspan = (unsigned)rowspan&0x7FFF;
            ff_lh_prefsize(child[y*cols + x], &cell[y*cols + x].pw, &cell[y*cols + x].ph, FF_NOFLAGS);
            for (j=0; j < rowspan; j++)
                for (i=0; i < colspan; i++)
                    cell[(j + y)*cols + x + i].spanned = FF_YES;
        }
    x = y = 0;
    for (i=0; i < children; i++) {
        while (y < rows) {
            if (!cell[y*cols + x].spanned && !cell[y*cols + x].win) break;
            x++;
            if (x == cols) {
                x = 0;
                y++;
            }
        }
        if (y == rows) break;
        colspan = ff_geti_def(child[i], "grid-column-span", 1);
        rowspan = ff_geti_def(child[i], "grid-row-span", 1);
        if (colspan < 1) colspan = 1;
        if (rowspan < 1) rowspan = 1;
        if (colspan > 1 || rowspan > 1) continue;
        cell[y*cols + x].win = child[i];
        cell[y*cols + x].cspan = cell[y*cols + x].rspan = 1;
        ff_lh_prefsize(child[i], &cell[y*cols + x].pw, &cell[y*cols + x].ph, FF_NOFLAGS);
    }
    for (x=0; x < cols; x++) {
        int w = 0;
        for (y=0; y < rows; y++) {
            if (cell[y*cols + x].cspan != 1) continue;
            if (w < cell[y*cols + x].pw) w = cell[y*cols + x].pw;
        }
        colw[x] = w;
    }
    for (y=0; y < rows; y++) {
        int h = 0;
        for (x=0; x < cols; x++) {
            if (cell[y*cols + x].rspan != 1) continue;
            if (h < cell[y*cols + x].ph) h = cell[y*cols + x].ph;
        }
        rowh[y] = h;
    }
    for (x=0; x < cols; x++) {
        for (y=0; y < rows; y++) {
            if (cell[y*cols + x].cspan == 1 && cell[y*cols + x].rspan == 1) continue;
            for (i=allw=0; i < cell[y*cols + x].cspan; i++)
                allw += colw[x + i];
            if (allw < cell[y*cols + x].pw) {
                const int delta = cell[y*cols + x].pw - allw;
                for (i=0; i < cell[y*cols + x].cspan; i++)
                    colw[x + i] = ff_round_int(
                        (float)colw[x + i] +
                        (float)delta*((float)colw[x + i]/(float)allw));
            }
            for (i=allh=0; i < cell[y*cols + x].rspan; i++)
                allh += rowh[y + i];
            if (allh < cell[y*cols + x].ph) {
                const int delta = cell[y*cols + x].ph - allh;
                for (i=0; i < cell[y*cols + x].rspan; i++)
                    rowh[y + i] = ff_round_int(
                        (float)rowh[y + i] +
                        (float)delta*((float)rowh[y + i]/(float)allh));
            }
        }
    }
    if (samewidth) {
        for (cw=x=0; x < cols; x++) if (cw < colw[x]) cw = colw[x];
        for (x=0; x < cols; x++) colw[x] = cw;
    }
    if (sameheight) {
        for (ch=y=0; y < rows; y++) if (ch < rowh[y]) ch = rowh[y];
        for (y=0; y < rows; y++) rowh[y] = ch;
    }
    for (allw=x=0; x < cols; x++) allw += colw[x];
    for (allh=y=0; y < rows; y++) allh += rowh[y];
    ff_prefsize(win, allw, allh);
    cx = cy = 0;
    if (allw != width) {
        const char* halign = ff_get(win, "grid-horizontal-align");
        if (!halign) halign = ff_get(win, "grid-align");
        if (halign) {
            if (!strcmp(halign, "fill")) {
                xscale = (float)width/(float)allw;
                for (allw=x=0; x < cols; x++) { colw[x] = (int)((float)colw[x]*xscale); allw += colw[x]; }
                colw[cols - 1] += (width - allw);
            } else if (!strcmp(halign, "center") && allw < width)
                cx = (width - allw)/2;
            else if (!strcmp(halign, "right") && allw < width)
                cx = width - allw;
        }
    }
    if (allh != height) {
        const char* valign = ff_get(win, "grid-vertical-align");
        if (!valign) valign = ff_get(win, "grid-align");
        if (valign) {
            if (!strcmp(valign, "fill")) {
                yscale = (float)height/(float)allh;
                for (allh=y=0; y < rows; y++) { rowh[y] = (int)((float)rowh[y]*yscale); allh += rowh[y]; }
                rowh[rows - 1] += (height - allh);
            } else if (!strcmp(valign, "center") && allh < height)
                cy = (height - allh)/2;
            else if (!strcmp(valign, "right") && allw < height)
                cy = height - allh;
        }
    }
    for (y=0; y < rows; y++) {
        j = cx;
        for (x=0; x < cols; x++) {
            if (cell[y*cols + x].win) {
                for (cw=0,i=x; i < x + cell[y*cols + x].cspan; i++) cw += colw[i];
                for (ch=0,i=y; i < y + cell[y*cols + x].rspan; i++) ch += rowh[i];
                if (cw < colw[x]) cw = colw[x];
                if (ch < rowh[y]) ch = rowh[y];
                ff_lh_place(cell[y*cols + x].win, cx, cy, cw, ch);
            }
            cx += colw[x];
        }
        cx = j;
        cy += rowh[y];
    }
    free(rowh);
    free(colw);
    free(cell);
}
