#ifndef __LFORMS_H_INCLUDED__
#error Please do not include this file directly. Use #include <lforms.h> instead
#endif

typedef void (*ff_layout_proc_t)(ff_window_t win, ff_window_t* child, int children, int width, int height);

ff_window_t ff_window(ff_window_t parent, int x, int y, int width, int height, unsigned flags);
int ff_valid(ff_window_t win);
ff_window_t* ff_all_windows(void);
unsigned ff_flags(ff_window_t win);
int ff_ispopup(ff_window_t win);
void ff_move(ff_window_t win, int x, int y);
void ff_resize(ff_window_t win, int width, int height);
void ff_place(ff_window_t win, int x, int y, int width, int height);
void ff_paint(ff_window_t win);
void ff_damage(ff_window_t win, int x1, int y1, int x2, int y2);
ff_window_t ff_parent(ff_window_t win);
ff_window_t ff_toplevel(ff_window_t win);
ff_window_t* ff_children(ff_window_t win);
ff_window_t* ff_npchildren(ff_window_t win);
void ff_free_children(ff_window_t* children);
ff_window_t ff_default(ff_window_t win, ff_window_t child);
void ff_translate(int* x, int* y, ff_window_t from, ff_window_t to);
void ff_area(ff_window_t win, int* x, int* y, int* width, int* height);
ff_window_t ff_pick(ff_window_t win, int x, int y);
ff_window_t ff_find(ff_window_t win, const char* name, int cmp, const void* value);
ff_window_t ff_findi(ff_window_t win, const char* name, int cmp, int value);
void ff_pointer(int* x, int* y);
void ff_layout(ff_window_t win, ff_layout_proc_t layout);
void ff_relayout(ff_window_t win);
void ff_prefsize(ff_window_t win, int width, int height);
void ff_pack(ff_window_t win, int direction);
void ff_padding(ff_window_t win, int left, int top, int right, int bottom);
void ff_margin(ff_window_t win, int left, int top, int right, int bottom);
void ff_show(ff_window_t win, int show);
int ff_shown(ff_window_t win);
void ff_modal(ff_window_t win);
void ff_focus(ff_window_t win);
int ff_focused(ff_window_t win);
void ff_enable(ff_window_t win, int enable);
int ff_enabled(ff_window_t win);
int ff_timer(ff_window_t win, int msorremove);
void ff_freeze(ff_window_t win);
void ff_thaw(ff_window_t win);
int ff_frozen(ff_window_t win);
ff_font_t ff_font_of(ff_window_t win);
void ff_cursor(ff_window_t win, ff_uintptr_t cursor);
