#ifndef __LFORMS_H_INCLUDED__
#error Please do not include this file directly. Use #include <lforms.h> instead
#endif

#ifdef __GNUC__
#ifndef __WORDSIZE
#ifdef _WIN32
#ifdef _WIN64
#define __WORDSIZE 64
#else
#define __WORDSIZE 32
#endif
#else
#error Cannot figure out the pointer size, please update utils.h
#endif
#endif
#if __WORDSIZE == 64
typedef long ff_intptr_t;
typedef unsigned long ff_uintptr_t;
#else
typedef int ff_intptr_t;
typedef unsigned ff_uintptr_t;
#endif
#define LFORMS_INTPTR_OK
#endif

#ifdef __WATCOMC__
#if defined(__COMPACT__) || defined(__LARGE__)
typedef long long ff_intptr_t;
typedef unsigned long long ff_uintptr_t;
#else
typedef long ff_intptr_t;
typedef unsigned long ff_uintptr_t;
#endif
#define LFORMS_INTPTR_OK
#endif

#ifdef LFORMS_INTPTR_OK
#undef LFORMS_INTPTR_OK
#else
#error Cannot figure out the pointer size, please update utils.h
#endif

char* ff_strdup(const char* s);
void ff_free(void* ptr);
int ff_streq_nocase(const char* a, const char* b);
int ff_round_int(float f);
int ff_qsort_strcmp(const void* a, const void* b);
int ff_qsort_int(const void* a, const void* b);
int ff_unrepeat(void* base, size_t nmemb, size_t size);
int ff_rect_over_rect(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2, int by2);
