#ifndef __LFORMS_H_INCLUDED__
#error Please do not include this file directly. Use #include <lforms.h> instead
#endif

typedef struct _ff_namevalue_t
{
    const char* name;
    void* value;
} ff_namevalue_t;
typedef struct _ff_event_t
{
    void* dest;
    unsigned event;
    int x, y, z;
    void* p;
} ff_event_t;
typedef int (*ff_destructor_proc_t)(void* obj);
typedef int (*ff_handler_proc_t)(void* obj, ff_event_t* event, void* data);

void* ff_new(size_t size);
void ff_destructor(void* obj, ff_destructor_proc_t proc);
void ff_destroy(void* obj);
void ff_superior(void* obj, void* sup);
void ff_link(void* obj, unsigned event, ff_handler_proc_t handler, void* data);
void ff_unlink(void* obj, unsigned event, ff_handler_proc_t handler);
int ff_send(void* obj, unsigned event, int x, int y, int z, void* p, unsigned flags);
int ff_forward(void* obj, ff_event_t* ev);
int ff_redirect(void* obj, ff_event_t* ev, void* data);
void ff_post(void* obj, unsigned event, int x, int y, int z, void* p, unsigned flags);
void ff_set(void* obj, const char* name, void* value);
void* ff_get(void* obj, const char* name);
void ff_setu(void* obj, const char* name, unsigned u);
void ff_seti(void* obj, const char* name, int i);
void ff_setcs(void* obj, const char* name, const char* value);
int ff_geti(void* obj, const char* name);
int ff_geti_def(void* obj, const char* name, int def);
int ff_get_or_fail(void* obj, const char* name, void** value);
int ff_geti_or_fail(void* obj, const char* name, int* value);
unsigned ff_getu(void* obj, const char* name);
unsigned ff_getu_def(void* obj, const char* name, unsigned def);
int ff_getu_or_fail(void* obj, const char* name, unsigned* value);
