#ifndef __LFORMS_H_INCLUDED__
#error Please do not include this file directly. Use #include <lforms.h> instead
#endif

/* Structure for FF_LBITEMPAINT event */
typedef struct _ff_lbitempaint_t
{
    ff_gc_t gc;
    const char* text;
    void* data;
    int x, y, w, h;
    unsigned flags;
    ff_color_t bg, fg, abg, afg;
} ff_lbitempaint_t;

ff_window_t ff_list(ff_window_t parent, const char** item, void** data, int items, int selection);
void ff_list_clear(ff_window_t lb);
void ff_list_set(ff_window_t lb, const char** item, void** data, int items, int selection);
int ff_list_add(ff_window_t lb, const char* item, void* data);
void ff_list_remove(ff_window_t lb, int index);
int ff_list_items(ff_window_t lb);
int ff_list_itemindex(ff_window_t lb, const char* item);
int ff_list_dataindex(ff_window_t lb, void* data);
const char* ff_list_text(ff_window_t lb, int index);
void* ff_list_data(ff_window_t lb, int index);
void ff_list_replace(ff_window_t lb, int index, const char* text, void* data);
void ff_list_select(ff_window_t lb, int index, int single);
void ff_list_deselect(ff_window_t lb, int index, int single);
int ff_list_selected(ff_window_t lb, int index);
int ff_list_selection(ff_window_t lb);
int ff_list_pick(ff_window_t lb, int x, int y);
int ff_list_itemarea(ff_window_t lb, int index, int* x, int* y, int* width, int* height);
void ff_list_reveal(ff_window_t lb, int index);
