#ifndef __LFORMS_H_INCLUDED__
#error Please do not include this file directly. Use #include <lforms.h> instead
#endif

typedef struct _ff_window_t* ff_window_t;
typedef struct _ff_gc_t* ff_gc_t;
typedef struct _ff_bitmap_t* ff_bitmap_t;
typedef struct _ff_font_t* ff_font_t;
typedef unsigned ff_color_t;
typedef int (*ff_font_enum_proc)(const char* name, const int* size, int sizes, unsigned flags, void* data);

void ff_damaged(ff_gc_t gc, int* x1, int* y1, int* x2, int* y2);
int ff_isdamaged(ff_gc_t gc, int x1, int y1, int x2, int y2);

void ff_color(ff_gc_t gc, ff_color_t color);
void ff_color_attr(ff_gc_t gc, ff_window_t win, const char* name, ff_color_t def);
ff_color_t ff_color_get(ff_window_t win, const char* name, ff_color_t def);
void ff_font(ff_gc_t gc, ff_font_t font);
void ff_fill(ff_gc_t gc, int x1, int y1, int x2, int y2);
void ff_rect(ff_gc_t gc, int x1, int y1, int x2, int y2);
void ff_line(ff_gc_t gc, int x1, int y1, int x2, int y2);
void ff_oval(ff_gc_t gc, int x1, int y1, int x2, int y2);
void ff_disc(ff_gc_t gc, int x1, int y1, int x2, int y2);
void ff_pixel(ff_gc_t gc, int x, int y);
void ff_text(ff_gc_t gc, int x, int y, const char* text);
void ff_text_size(ff_gc_t gc, const char* text, int* width, int* height);
void ff_draw(ff_gc_t gc, int x, int y, ff_bitmap_t bmp);

ff_bitmap_t ff_bitmap(int width, int height, const ff_color_t* pixels);
void ff_bitmap_free(ff_bitmap_t bmp);
void ff_bitmap_pixels(ff_bitmap_t bmp, const ff_color_t* pixels);
void ff_bitmap_size(ff_bitmap_t bmp, int* width, int* height);
ff_gc_t ff_bitmap_gc(ff_bitmap_t bmp);

ff_font_t ff_font_search(const char* name, int size, unsigned flags);
ff_font_t ff_default_font(int which);
const char* ff_font_name(ff_font_t font);
int ff_font_size(ff_font_t font);
void ff_font_text_size(ff_font_t font, const char* text, int* width, int* height);
unsigned ff_font_flags(ff_font_t font);
void ff_font_enum(ff_font_enum_proc proc, void* data, unsigned enum_flags);
