#ifndef __LFORMS_H_INCLUDED__
#error Please do not include this file directly. Use #include <lforms.h> instead
#endif

/* Little Forms constant definitions. Ordered by primary purpose. Some of them
 * can be used for other purposes. */

/* Generic defines */
#define FF_NOTHING 0
#define FF_NOFLAGS 0
#define FF_NO 0
#define FF_YES 1
#define FF_TRUE 1
#define FF_FALSE 0
#define FF_REMOVE -1
#define FF_NOCHANGE 0
#define FF_IGNORE -1
#define FF_ADD 1
#define FF_VERTICAL 0
#define FF_HORIZONTAL 1
#define FF_BOTH 2
#define FF_AUTO -1
#define FF_MAXWEIGHT 0xFFF

/* Comparison */
#define FF_IS 2
#define FF_ISNOT 3
#define FF_ISINT 4
#define FF_ISNOTINT 5
#define FF_ISSTR 6
#define FF_ISNOTSTR 7
#define FF_ISABOVE 8
#define FF_ISBELOW 9
#define FF_ISEQUALORABOVE 10
#define FF_ISEQUALORBELOW 11

/* Events */
#define FF_DESTROY 1
#define FF_BUBBLEMASK 2
#define FF_CLOSE 3
#define FF_CHILD 4
#define FF_AREA 5
#define FF_VISIBILITY 6
#define FF_ENABLE 7
#define FF_QUERY 8
#define FF_PAINT 9
#define FF_SET 10
#define FF_GET 11
#define FF_KEYDOWN 12
#define FF_KEYUP 13
#define FF_TEXT 14
#define FF_PRESS 15
#define FF_RELEASE 16
#define FF_MOTION 17
#define FF_HOVER 18
#define FF_LEAVE 19
#define FF_WHEEL 20
#define FF_DBLCLICK 21
#define FF_FOCUS 22
#define FF_BLUR 23
#define FF_ACTION 24
#define FF_CHANGE 25
#define FF_CARET 26
#define FF_TIMER 27
#define FF_SELECT 28
#define FF_FREEZE 29
#define FF_THAW 30
#define FF_ACTIVATE 31
#define FF_APPFOCUS 32
#define FF_APPBLUR 33
#define FF_NEWFONT 34
#define FF_LOCAL 8192
#define FF_USER 16384

/* Event flags */
#define FF_BUBBLE 0x0001U

/* Window Flags */
#define FF_NORESIZE 0x00000001U
#define FF_NOFRAME 0x00000002U
#define FF_INVISIBLE 0x00000004U
#define FF_POPUP 0x00000008U
#define FF_DOUBLEBUFFER 0x00000010U
#define FF_OPENGL 0x00000020U
#define FF_TEXTINPUT 0x00000040U
#define FF_CENTERED 0x00000080U
#define FF_AUTOHIDE 0x00000100U
#define FF_TOPMOST 0x00000200U
#define FF_DISABLED 0x00000400U
#define FF_FROZEN 0x00000800U

/* Modifiers */
#define FF_ALT 0x0001U
#define FF_CONTROL 0x0002U
#define FF_SHIFT 0x0004U

/* Keys */
#define FFK_NONE 0
#define FFK_BACKSPACE 8
#define FFK_TAB 9
#define FFK_LINEFEED 10
#define FFK_CLEAR 11
#define FFK_RETURN 13
#define FFK_PAUSE 14
#define FFK_SYSREQ 16
#define FFK_ESCAPE 27
#define FFK_DELETE 28
#define FFK_HOME 335
#define FFK_LEFT 336
#define FFK_RIGHT 337
#define FFK_UP 338
#define FFK_DOWN 339
#define FFK_PAGEUP 340
#define FFK_PAGEDOWN 341
#define FFK_END 342
#define FFK_INSERT 343
#define FFK_NUM_LOCK 344
#define FFK_SCROLL_LOCK 345
#define FFK_CAPS_LOCK 346
#define FFK_F1 350
#define FFK_F2 351
#define FFK_F3 352
#define FFK_F4 353
#define FFK_F5 354
#define FFK_F6 355
#define FFK_F7 356
#define FFK_F8 357
#define FFK_F9 358
#define FFK_F10 359
#define FFK_F11 360
#define FFK_F12 361
#define FFK_F13 362
#define FFK_F14 363
#define FFK_LSHIFT 3128
#define FFK_RSHIFT 3129
#define FFK_LCONTROL 3130
#define FFK_RCONTROL 3131
#define FFK_LALT 3132
#define FFK_RALT 3133
#define FFK_LSUPER 3134
#define FFK_RSUPER 3135

#define FFK_SPACE 32
#define FFK_EXCLAM 33
#define FFK_QUOTEDBL 34
#define FFK_NUMBERSIGN 35
#define FFK_DOLLAR 36
#define FFK_PERCENT 37
#define FFK_AMPERSAND 38
#define FFK_APOSTROPHE 39
#define FFK_PARENLEFT 40
#define FFK_PARENRIGHT 41
#define FFK_ASTERISK 42
#define FFK_PLUS 43
#define FFK_COMMA 44
#define FFK_MINUS 45
#define FFK_PERIOD 46
#define FFK_SLASH 47
#define FFK_0 48
#define FFK_1 49
#define FFK_2 50
#define FFK_3 51
#define FFK_4 52
#define FFK_5 53
#define FFK_6 54
#define FFK_7 55
#define FFK_8 56
#define FFK_9 57
#define FFK_COLON 58
#define FFK_SEMICOLON 59
#define FFK_LESS 60
#define FFK_EQUAL 61
#define FFK_GREATER 62
#define FFK_QUESTION 63
#define FFK_AT 64
#define FFK_A 65
#define FFK_B 66
#define FFK_C 67
#define FFK_D 68
#define FFK_E 69
#define FFK_F 70
#define FFK_G 71
#define FFK_H 72
#define FFK_I 73
#define FFK_J 74
#define FFK_K 75
#define FFK_L 76
#define FFK_M 77
#define FFK_N 78
#define FFK_O 79
#define FFK_P 80
#define FFK_Q 81
#define FFK_R 82
#define FFK_S 83
#define FFK_T 84
#define FFK_U 85
#define FFK_V 86
#define FFK_W 87
#define FFK_X 88
#define FFK_Y 89
#define FFK_Z 90
#define FFK_BRACKETLEFT 91
#define FFK_BACKSLASH 92
#define FFK_BRACKETRIGHT 93
#define FFK_CARET 94
#define FFK_UNDERSCORE 95
#define FFK_GRAVE 96
#define FFK_BRACELEFT 123
#define FFK_BAR 124
#define FFK_BRACERIGHT 125
#define FFK_TILDE 126

/* Color macros */
#define FF_RGB(r,g,b) ((ff_color_t)(((((ff_color_t)(r))&0xFFU)<<16U)|((((ff_color_t)(g))&0xFFU)<<8U)|(((ff_color_t)(b))&0xFFU)))
#define FF_RGB_ATTR(r,g,b) ((void*)FF_RGB(r,g,b))
#define FF_RED(rgb) (((rgb)&0xFF0000U)>>16U)
#define FF_GREEN(rgb) (((rgb)&0xFF00U)>>8U)
#define FF_BLUE(rgb) ((rgb)&0xFFU)

/* Color constants (note: if this changes, update xpm.c symbols) */
#define FF_3DFACE_COLOR FF_RGB(170, 170, 170)
#define FF_3DSHADOW_COLOR FF_RGB(85, 85, 85)
#define FF_3DDARK_COLOR FF_RGB(0, 0, 0)
#define FF_3DLIGHT_COLOR FF_RGB(255, 255, 255)
#define FF_3DTEXT_COLOR FF_RGB(0, 0, 0)
#define FF_3DDISABLEDTEXT_COLOR FF_RGB(85, 85, 85)
#define FF_ACTIVE_COLOR FF_RGB(255, 255, 255)
#define FF_ACTEXT_COLOR FF_RGB(0, 0, 0)
#define FF_EDITOR_COLOR FF_RGB(255, 255, 255)
#define FF_EDTEXT_COLOR FF_RGB(0, 0, 0)
#define FF_EDDISABLEDTEXT_COLOR FF_RGB(127, 127, 127)
#define FF_TRACK_COLOR FF_RGB(127, 127, 127)
#define FF_DARKTRACK_COLOR FF_RGB(81, 81, 81)
#define FF_SCROLLBAR_BORDER_COLOR FF_RGB(0, 0, 0)
#define FF_SCROLLBAR_PAD_COLOR FF_RGB(174, 174, 174)
#define FF_SCROLLBAR_COLOR FF_RGB(127, 127, 127)
#define FF_MENU_COLOR FF_RGB(0, 0, 0)
#define FF_MENUTEXT_COLOR FF_RGB(255, 255, 255)

/* Font flags */
#define FF_BOLD 0x0001U
#define FF_ITALIC 0x0002U
#define FF_UNDERLINE 0x0004U
#define FF_STRIKEOUT 0x0008U
#define FF_MONOSPACE 0x0010U
#define FF_PROPORTIONAL 0x0020U
#define FF_EXACT_FONT 0x8000U

/* Default fonts */
#define FF_STANDARD_FONT 0
#define FF_BOLD_FONT 1
#define FF_ITALIC_FONT 2
#define FF_MONOSPACE_FONT 3
#define FF_BIG_FONT 4
#define FF_SMALL_FONT 5

/* Cursors */
#define FF_ARROW 1
#define FF_HARROWS 2
#define FF_VARROWS 3
#define FF_TLBRARROWS 4
#define FF_TRBLARROWS 5
#define FF_4DARROWS 6
#define FF_WAIT 7
#define FF_UNAVAILABLE 8
#define FF_IBEAM 9
#define FF_CROSSHAIR 10

/* Scrollbar Flags */
#define FF_SBVERTICAL 0x0000U
#define FF_SBHORIZONTAL 0x0001U
#define FF_SBBUTTON1 0x0002U
#define FF_SBBUTTON2 0x0004U
#define FF_SBNOBUTTONS 0x0008U
#define FF_SBNOTIMER 0x0010U

/* List events */
#define FF_LBITEMPAINT (FF_LOCAL)

/* List item Flags */
#define FF_LBISELECTED 0x0001U

/* Layout helper flags */
#define FF_LHINVISIBLE 0x0001U
