#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t progress;    /* The progress bar */

/* Called when the animate button is clicked */
static int animate(void* btn, ff_event_t* ev, void* data)
{
    /* Reset the progress */
    ff_seti(progress, "progress", 0);

    /* Setup a timer to update the progress */
    ff_timer(main_frame, 20);

    return FF_YES;
}

/* Called when the animate button is clicked */
static int reset(void* btn, ff_event_t* ev, void* data)
{
    /* Reset the progress */
    ff_seti(progress, "progress", 0);

    /* Stop the timer */
    ff_timer(main_frame, -1);

    return FF_YES;
}

/* Called every timer tick to animate the progress */
static int timer(void* frm, ff_event_t* ev, void* data)
{
    /* Increase the progress or stop if we reached the max value */
    if (ff_geti(progress, "progress") < ff_geti(progress, "max"))
        ff_seti(progress, "progress", ff_geti(progress, "progress")+1);
    else
        ff_timer(main_frame, -1);
    return FF_YES;
}

/* Entry point */
int main(int argc, char** argv)
{
    ff_window_t box;    /* Helper container box */

    /* Initialize */
    if (!ff_init(argc, argv, "Progress"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Progress Example", NULL,
                              320, 60,
                              FF_NOFLAGS);

    /* Set the layout to a vertical stack */
    ff_layout(main_frame, ff_stack);
    ff_seti(main_frame, "padding-around", 15);
    ff_seti(main_frame, "stack-spacing", 6);

    /* Create a label control */
    ff_label(main_frame, "Current progress:");

    /* Create the progress control */
    progress = ff_progress(main_frame, 500, 0);

    /* Create buttons for animation */
    box = ff_box(main_frame, NULL, "none");
    ff_layout(box, ff_border);
    ff_set(ff_button(box, "Reset", reset, NULL), "border-align", "left");
    ff_set(ff_button(box, "Animate", animate, NULL), "border-align", "right");
    ff_seti(ff_find(box, "caption", FF_ISSTR, "Animate"), "default", FF_YES);
    ff_default(main_frame, ff_find(box, "caption", FF_ISSTR, "Animate"));

    /* Link the timer handler on the main frame that will be used to
     * animate (by increasing the progress of) the main control. */
    ff_link(main_frame, FF_TIMER, timer, NULL);

    /* Pack the window vertically to fit the preferred size
     * of its chilren */
    ff_pack(main_frame, FF_VERTICAL);

    /* Enter main loop */
    return ff_run();
}
