#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t secondary;   /* A secondary frame*/

/* Called when a close button is pressed */
static int close(void* win, ff_event_t* ev, void* data)
{
    ff_destroy(ff_toplevel(win));
    return FF_YES;
}

/* Called when the 'show global modal' button is clicked */
static int global_modal(void* win, ff_event_t* ev, void* data)
{
    /* Create a frame without a parent window */
    ff_window_t modal = ff_frame(NULL, "Global Modal", NULL,
                                150, 100, FF_INVISIBLE);
    ff_layout(modal, ff_stack);

    /* Add just a button to close this window */
    ff_button(modal, "Close This", close, NULL);

    /* Modalize the frame - this will show the frame as a global modal
     * frame since it has no parent.  Every other window in the
     * application will be disabled until this frame is closed */
    ff_modal(modal);

    return FF_YES;
}

/* Called when the 'show parented modal' button is clicked */
static int parented_modal(void* win, ff_event_t* ev, void* data)
{
    /* Create a frame using the toplevel window of the button that
     * was clicked as the parent of the frame */
    ff_window_t modal = ff_frame(ff_toplevel(win), "Parented Modal",
                                NULL, 150, 100, FF_NOFLAGS);
    ff_layout(modal, ff_stack);

    /* Add a button to show a global modal */
    ff_button(modal, "Show global modal", global_modal, NULL);

    /* Add another button to close this modal */
    ff_button(modal, "Close This", close, NULL);

    /* Modalize the frame - this will show the frame as a parented modal
     * window.  The parent window will be disabled until this frame is
     * closed but other windows will be usable */
    ff_modal(modal);

    return FF_YES;
}

/* Entry point */
int main(int argc, char** argv)
{
    /* Initialize */
    if (!ff_init(argc, argv, "Modal"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Modal Windows Test", NULL,
                              250, 190,
                              FF_CENTERED);
    ff_layout(main_frame, ff_stack);
    ff_seti(main_frame, "padding-around", 15);
    ff_seti(main_frame, "stack-spacing", 10);

    /* Create a secondary frame */
    secondary = ff_frame(main_frame, "Secondary Frame", NULL,
                         250, 190,
                         FF_NOFLAGS);
    ff_layout(secondary, ff_stack);
    ff_seti(secondary, "padding-around", 15);
    ff_button(secondary, "Another parented modal", parented_modal, NULL);

    /* Put a couple of buttons to show other windows */
    ff_button(main_frame, "Show parented modal", parented_modal, NULL);
    ff_button(main_frame, "Show global modal", global_modal, NULL);

    /* Enter main loop */
    return ff_run();
}
