#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t user_name;   /* User name field */
static ff_window_t greeting;    /* Greeting label */
static ff_window_t button;      /* Greet button */

/* Called when the button is pressed */
static int greet(void* button, ff_event_t* ev, void* data)
{
    char* name = ff_get(user_name, "text");
    char* greet_text = malloc(8 + strlen(name));
    sprintf(greet_text, "Hello %s!", name);
    ff_set(greeting, "caption", greet_text);
    free(greet_text);
    return 1;
}

/* Entry point */
int main(int argc, char** argv)
{
    /* Initialize */
    if (!ff_init(argc, argv, "Hello"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Hello Little Forms", NULL,
                              300, 120,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_stack);
    ff_seti(main_frame, "padding-around", 15);
    ff_seti(main_frame, "stack-spacing", 6);

    /* Add the widgets */
    ff_label(main_frame, "What is your name?");
    user_name = ff_field(main_frame, "");
    button = ff_button(main_frame, "Greet!", greet, NULL);
    ff_set(button, "align-horizontal", "right");
    greeting = ff_label(main_frame, "");
    ff_focus(user_name);

    /* Set the default control to be the button */
    ff_default(main_frame, button);

    /* Enter main loop */
    return ff_run();
}
