#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */

/* The paint handler is called to paint the window */
static int paint(void* win, ff_event_t* ev, void* data)
{
    ff_gc_t gc = ev->p; /* The graphics context */

    /* Make sure we really have a graphics context */
    if (gc) {
        int w, h, tw, th;

        /* Get the window's size */
        ff_area(win, NULL, NULL, &w, &h);

        /* Fill it with the background color */
        ff_color_attr(gc, win, "background", FF_3DFACE_COLOR);
        ff_fill(gc, 0, 0, w, h);

        /* Set the color to blue */
        ff_color(gc, FF_RGB(0, 0, 255));

        /* Draw a disc (filled oval) inside the window */
        ff_disc(gc, 4, 4, w - 5, h - 5);

        /* Set the color to red */
        ff_color(gc, FF_RGB(255, 0, 0));

        /* Draw two crossing lines */
        ff_line(gc, 0, 0, w, h);
        ff_line(gc, w, 0, 0, h);

        /* Set the color to green */
        ff_color(gc, FF_RGB(0, 255, 0));

        /* Draw a circle and a rectangle around the frame */
        ff_oval(gc, 0, 0, w - 1, h - 1);
        ff_rect(gc, 2, 2, w - 3, h - 3);

        /* Set color to yellow */
        ff_color(gc, FF_RGB(255, 255, 0));

        /* Draw centered text */
        ff_text_size(gc, "Hello!", &tw, &th);               /* Text's size */
        ff_text(gc, (w - tw)/2, (h - th)/2 + th, "Hello!"); /* Draw it */
    }

    /* 1 means that we handled the event */
    return 1;
}

/* Entry point */
int main(int argc, char** argv)
{
    /* Initialize */
    if (!ff_init(argc, argv, "Drawing Example"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Drawing Example", NULL,
                              320, 320,
                              FF_DOUBLEBUFFER); /* Enable double buffering */

    /* Link the FF_PAINT event with the paint handler */
    ff_link(main_frame, FF_PAINT, paint, NULL);

    /* Enter main loop */
    return ff_run();
}

