program RuntimeBasic;
{$MODE OBJFPC}{$H+}
uses
//  HeapTrc,
  Math,
{$IFNDEF RBRUN}
  RBUIGtk,
  RBUI,
{$ENDIF}
  RBUtil, RBSrc, RBProg, RBCpl, RBVM;
var
  Prg: TProgram;
  VM: TVirtualMachine;
  Cpl: TCompiler;
  Src: TSource;
begin
  SetExceptionMask([exInvalidOp, exDenormalized, exZeroDivide, exOverflow, exUnderflow, exPrecision]);
  if ParamStr(1)='' then begin
{$IFDEF RBRUN}
    Writeln('Runtime BASIC Runner Version ', VersionStr);
    Writeln('Usage: rbrun <filename.bas>');
{$ELSE}
    UserInterface:=TGTK2UserInterface.Create(nil);
    if not UserInterface.Initialize then Exit;
    UserInterface.Run;
    UserInterface.Free;
{$ENDIF}
  end else begin
    Prg:=TProgram.Create(nil);
    Cpl:=TCompiler.Create(Prg);
    VM:=TVirtualMachine.Create(Prg);
    Src:=TSource.Create(Prg);
    try
      Src.LoadFromFile(ParamStr(1));
      Cpl.Prog:=Prg;
      Cpl.AddSource(Src);
      Cpl.Compile;
      VM.Run(Cpl.Prog);
    finally
      Prg.Free;
    end;
  end;
end.
