unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, types, FileUtil, Forms, Controls, Graphics, Dialogs,
  StdCtrls, Menus, ExtCtrls, ComCtrls, RuntimeBASIC, RBVMStor, RBNative;

type

  { TMain }

  TMain = class(TForm, INativeObject)
    Code: TMemo;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    mFileOpen: TMenuItem;
    mFileSave: TMenuItem;
    MenuItem5: TMenuItem;
    mFileNew: TMenuItem;
    mFileFormat: TMenuItem;
    mOptionsClearOutput: TMenuItem;
    mOptionsAutoformat: TMenuItem;
    mOptions: TMenuItem;
    mFileExit: TMenuItem;
    mFile: TMenuItem;
    mFileRunCode: TMenuItem;
    OpenDialog1: TOpenDialog;
    Output: TMemo;
    RBStandardRuntimeLibrary1: TRBStandardRuntimeLibrary;
    RuntimeBASIC1: TRuntimeBASIC;
    RuntimeBASICCustomInputOutput1: TRuntimeBASICCustomInputOutput;
    SaveDialog1: TSaveDialog;
    Splitter1: TSplitter;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    procedure CodeKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure FormCreate(Sender: TObject);
    procedure mFileExitClick(Sender: TObject);
    procedure mFileFormatClick(Sender: TObject);
    procedure mFileNewClick(Sender: TObject);
    procedure mFileOpenClick(Sender: TObject);
    procedure mFileRunCodeClick(Sender: TObject);
    procedure mFileSaveClick(Sender: TObject);
    procedure mOptionsClearOutputClick(Sender: TObject);
    procedure RuntimeBASIC1Error(Sender: TObject; ErrorMessage: string; Column, Row: Integer);
    procedure RuntimeBASICCustomInputOutput1OutputNewLine(Sender: TObject);
    procedure RuntimeBASICCustomInputOutput1OutputString(Sender: TObject; AString: string);
    procedure RuntimeBASICCustomInputOutput1OutputTab(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton7Click(Sender: TObject);
  private
    { private declarations }
    PreviousLine: Integer;
    procedure CheckLineChange;
    procedure FormatLine(Line: Integer);
  public
    { public declarations }
    procedure MethodCall(ANameID: Integer; Args: TNativeArguments; var Result: TVMValue);
    procedure SetProperty(ANameID: Integer; AValue: TVMValue);
    procedure AddReference;
    procedure ReleaseReference;
  end;

var
  Main: TMain;

implementation

uses
  RBFmt;

{$R *.lfm}

{ TMain }

procedure TMain.FormCreate(Sender: TObject);
begin
  {$IFDEF WINDOWS}
  Code.Font.Name:='Fixedsys';
  Output.Font.Name:='Fixedsys';
  {$ENDIF}
  RuntimeBASIC1.Prog.Vars^.Add('VERSION');
  RuntimeBASIC1.Prog.Vars^.Add('FORM');
end;

procedure TMain.CodeKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  CheckLineChange;
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: boolean);
begin
  CanClose:=MessageDlg('Exit', 'Are you sure? Any changes you have made will be lost', mtConfirmation, mbYesNo, 0)=mrYes;
end;

procedure TMain.mFileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMain.mFileFormatClick(Sender: TObject);
var
  I: Integer;
begin
  for I:=0 to Code.Lines.Count - 1 do FormatLine(I);
end;

procedure TMain.mFileNewClick(Sender: TObject);
begin
  if MessageDlg('New File', 'Are you sure? Any changes will be lost', mtConfirmation, mbYesNo, 0)=mrYes then Code.Text:='';
end;

procedure TMain.mFileOpenClick(Sender: TObject);
begin
  if MessageDlg('Open File', 'Are you sure? Any changes will be lost', mtConfirmation, mbYesNo, 0) <> mrYes then Exit;
  if OpenDialog1.Execute then try
    Code.Lines.LoadFromFile(OpenDialog1.FileName);
  except
    MessageDlg('Error', 'Failed to open ' + OpenDialog1.FileName, mtError, [mbOK], 0);
    Code.Text:='';
  end;
end;

procedure TMain.mFileRunCodeClick(Sender: TObject);
var
  V: TVMValue;
begin
  if RuntimeBASIC1.CompileSource(Code.Text) then begin
    SetObject(V, Self);
    RuntimeBASIC1.VirtualMachine.GlobalStorage.Write(RuntimeBASIC1.Prog.Vars^.Find('FORM'), V);
    RuntimeBASIC1.Run;
  end;
end;

procedure TMain.mFileSaveClick(Sender: TObject);
begin
  if SaveDialog1.Execute then try
    Code.Lines.SaveToFile(SaveDialog1.FileName);
  except
    MessageDlg('Error', 'Failed to save ' + SaveDialog1.FileName, mtError, [mbOK], 0);
  end;
end;

procedure TMain.mOptionsClearOutputClick(Sender: TObject);
begin
  Output.Text:='';
end;

procedure TMain.RuntimeBASIC1Error(Sender: TObject; ErrorMessage: string; Column, Row: Integer);
begin
  MessageDlg('Error', 'Error at ' + IntToStr(Row) + ':' + IntToStr(Column) + ': ' + ErrorMessage, mtError, [mbOK], 0);
  Code.CaretPos:=Point(Column - 1, Row - 1);
  Code.SetFocus;
end;

procedure TMain.RuntimeBASICCustomInputOutput1OutputNewLine(Sender: TObject);
begin
  Output.Text:=Output.Text + LineEnding;
  Output.SelStart:=Length(Output.Text);
  Application.ProcessMessages;
end;

procedure TMain.RuntimeBASICCustomInputOutput1OutputString(Sender: TObject; AString: string);
begin
  Output.Text:=Output.Text + AString;
  Output.SelStart:=Length(Output.Text);
  Application.ProcessMessages;
end;

procedure TMain.RuntimeBASICCustomInputOutput1OutputTab(Sender: TObject);
begin
  Output.Text:=Output.Text + #9;
  Output.SelStart:=Length(Output.Text);
  Application.ProcessMessages;
end;

procedure TMain.ToolButton1Click(Sender: TObject);
begin
  mFileRunCode.Click;
end;

procedure TMain.ToolButton3Click(Sender: TObject);
begin
  mFileExit.Click;
end;

procedure TMain.ToolButton4Click(Sender: TObject);
begin
  mFileFormat.Click;
end;

procedure TMain.ToolButton5Click(Sender: TObject);
begin
  mFileNew.Click;
end;

procedure TMain.ToolButton6Click(Sender: TObject);
begin
  mFileOpen.Click;
end;

procedure TMain.ToolButton7Click(Sender: TObject);
begin
  mFileSave.Click;
end;

procedure TMain.CheckLineChange;
begin
  if PreviousLine <> Code.CaretPos.y then begin
    if mOptionsAutoformat.Checked then FormatLine(PreviousLine);
    PreviousLine:=Code.CaretPos.y;
  end;
end;

procedure TMain.FormatLine(Line: Integer);
var
  Formatter: TFormatter;
  Formatted: String;
  SavedPosition: TPoint;
  SavedSelStart: Integer;
  SavedSelLength: Integer;
begin
  if Trim(Code.Lines[Line])='' then Exit;
  try
    SavedPosition:=Code.CaretPos;
    SavedSelStart:=Code.SelStart;
    SavedSelLength:=Code.SelLength;
    Formatter:=TFormatter.Create(nil);
    Formatter.Prog:=RuntimeBASIC1.Prog;
    Formatted:=Formatter.FormatLine(Code.Lines[Line]);
    if Formatted <> Code.Lines[Line] then begin
      Code.Lines[Line]:=Formatted;
      Code.CaretPos:=SavedPosition;
    end else begin
      Code.SelStart:=SavedSelStart;
      Code.SelLength:=SavedSelLength;
    end;
  finally
    FreeAndNil(Formatter);
  end;
end;

procedure TMain.MethodCall(ANameID: Integer; Args: TNativeArguments;
  var Result: TVMValue);
begin
  if RuntimeBASIC1.Prog.StringDB.IDToString(ANameID)='SHOW' then Show
  else if RuntimeBASIC1.Prog.StringDB.IDToString(ANameID)='CAPTION' then SetString(Result, Caption)
  else if RuntimeBASIC1.Prog.StringDB.IDToString(ANameID)='HIDE' then Hide
  else if RuntimeBASIC1.Prog.StringDB.IDToString(ANameID)='ALERT' then begin
    if Length(Args) > 0 then ShowMessage(ValueToString(Args[0]));
  end else raise ENativeError.Create('Unknown method ' + RuntimeBASIC1.Prog.StringDB.IDToString(ANameID));
end;

procedure TMain.SetProperty(ANameID: Integer; AValue: TVMValue);
begin
  if RuntimeBASIC1.Prog.StringDB.IDToString(ANameID)='CAPTION' then Caption:=ValueToString(AValue) else Caption:='';
end;

procedure TMain.AddReference;
begin
end;

procedure TMain.ReleaseReference;
begin
end;

end.

