unit RBError;
{$MODE OBJFPC}{$H+}
interface
const
  emNoError                     = 'No error';
  emSyntaxError                 = 'Syntax error';
  emNewLineExpectedButXFound    = 'New line expected but $ found';
  emUnexpectedEndOfCode         = 'Unexpected end of code';
  emInvalidRealNumber           = 'Invalid real number ($)';
  emInvalidIntegerNumber        = 'Invalid integer number ($)';
  emUnknownSymbol               = 'Unknown symbol $';
  emUnexpectedToken             = 'Unexpected $';
  emExpectedValueButXFound      = 'A value was expected but $ was found';
  emIdentifierExpectedButXFound = 'Identifier expected but $ was found';
  emCommaExpectedButXFound      = 'Comma expected but $ was found';
  emThenExpectedButXFound       = 'Then expected but $ was found';
  emElseOutsideOfIf             = 'Else outside of If';
  emNextOutsideOfFor            = 'Next outside of For';
  emWendOutsideOfWhile          = 'Wend outside of While';
  emDuplicateDefinitionOfX      = 'Duplicate definition of $';
  emMethodAlreadyDefined        = 'Method $ already defined';
  emCannotDefineMethodInMethod  = 'Cannot define a method inside another method';
  emUnknownMethod               = 'Unknown method $';
  emUnexpectedUseOfEnd          = 'Unexpected use of End';
  emInvalidEndUsage             = 'Invalid End usage';
  emMissingEndIf                = 'Missing End If';
  emNextExpectedButXFound       = 'Next expected but $ found';
  emWendExpectedButXFound       = 'Wend expected but $ found';
  emVariableNameExpectedInFor   = 'Variable name expected in For';
  emEqualExpectedAfterVarInFor  = 'Equal sign (''='') expected after variable in For';
  emToExpectedAfterExprInFor    = 'To expected after expression in For';
  emOpeningParenthesisExpected  = 'Opening parenthesis (''('') expected';
  emClosingParenthesisExpected  = 'Closing parenthesis ('')'') expected';
  emEqualExpectedInArrayAssign  = 'Equal sign (''='') expected in array assignment';
  emArrayIndexOutOfBounds       = 'Array index out of bounds';
  emInvalidArraySubscriptCount  = 'Invalid array subscript count';
  emInvalidArgumentCountToX     = 'Invalid argument count to $';
  emCannotUseSubXAsFunction     = 'Cannot use Sub $ as a Function';
  emInvalidDimensionCount       = 'Invalid dimension count (must be between 1 and 6 dimensions)';
  emVMStackUnderflow            = 'VM stack inderflow';
  emJumpStackOverflow           = 'Jumpstack overflow';
  emJumpStackUnderflow          = 'Jumpstack underflow';
  emInvalidOpCode               = 'Invalid OpCode $';
  emArithmeticValueExpected     = 'Arithmetic value expected';
  emInvalidType                 = 'Invalid type';
  emDivisionByZero              = 'Division by zero';
  emNoProgramForMethod          = 'No program for method';
  emInvalidMethodID             = 'Invalid method ID';
  emIntegerValueExpected        = 'Integer value expected';
  emDimSizeMustBeGreaterThanZero= 'Dimension sizes must be greater than zero';
  emValueIsNotAnArray           = 'The value is not an array';
  emValueCannotBeEmpty          = 'The value cannot be empty';
  emValueIsAMultidimArray       = 'The value is a multidimensional array';

function emFmt(const s: string; const r: string=''): string;

implementation

function emFmt(const s: string; const r: string): string;
var
  rp: Integer;
begin
  rp:=Pos('$', s);
  if rp=0 then Result:=s else Result:=Copy(s, 1, rp - 1) + r + Copy(s, rp + 1, Length(s));
end;

end.
