//---------------------------------------------------------------------------
#ifndef UtilsUnitH
#define UtilsUnitH
//---------------------------------------------------------------------------
#include "Strings.h"
#ifdef WindowsHPP
#include <vcl\ComCtrls.hpp>
#endif
//---------------------------------------------------------------------------
namespace NUtilities
{
    // Return the current date and time as a string of the format YYYY-MM-DD HH:MM:SS
    AString GetCurrentDateTime();
    // Return a human friendly description of size in bytes
    AString GetHumanFriendlySize(unsigned size);
    // Extract the filename alone without the extension and directories
    AString ExtractFileNameOnly(const AString& path);
    // Extract the filename with extension
    AString ExtractFileName(const AString& path);
    // Extract the directory path without the filename (that is, up to the last slash)
    AString ExtractDirectoryPath(const AString& path);
    // Normalize the given path by replacing all /s with \s and removing duplicate slashes
    AString NormalizePath(const AString& path);
    // Return the size of the file at the given path
    bool GetFileSize(const AString& path, unsigned& size);
    // Return true if the file at the given path exists
    bool FileExistsAt(const AString& path);
    // Return true if the file at the given path is read only
    bool IsFileReadOnly(const AString& path, bool& flag);
    // Set the read-only flag (for this user) for the file at the given path
    bool SetFileReadOnly(const AString& path, bool flag);
    // Force a directory path by creating any missing elements
    bool ForceDirectoryPath(const AString& path);
    // Copy the file at srcPath to dstPath (dstPath must include filename)
    bool DirectCopyFile(const AString& srcPath, const AString& dstPath);
    // Write the given buffer to the given file
    bool WriteBufferToFile(const AString& path, const void* buffer, size_t size);
    // Read the contents of the given file to a buffer and store it in the given pointer
    // Release the passed pointer with free()
    bool ReadFileToBuffer(const AString& path, void*& buffer, size_t& size, size_t extra=0);
    // Write the given string to the given file
    bool WriteStringToFile(const AString& path, const AString& text);
    // Read the the contents of the given file as a string and store it in the
    // passed string reference
    bool ReadStringFromFile(const AString& path, AString& text);
    // Split the given string at line ending characters (CRLF or LF) and return
    // it as a string array with one line per entry
    void SplitTextToLines(const AString& text, AStringArray& lines); 
    // Scan the given directory's contents
    bool ScanDirectoryContents(const AString& path, TDynArray<AString>& files, TDynArray<AString>& dirs);
    // Compare the given two files and return whether they have the same contents or not
    bool CompareFileContents(const AString& path1, const AString& path2, bool& identical);
#ifdef WindowsHPP
    // Show a dialog to browse for a folder
    bool BrowseForFolder(AString& path);
    // Show the given form modal centered into the parent form
    int ShowCenteredModal(TForm* parent, TForm* box);
    // Make a report list view to use the full row
    void EnableFullRowReportMode(TListView* view);
#endif
}
//---------------------------------------------------------------------------
#endif
