#ifndef OpenGLH
#define OpenGLH

#ifndef NO_OPENGL

// These macros are normally defined in windows.h but we can avoid including
// that behemoth of a header file by reimplementing them here so the OpenGL
// header files can use them
#ifndef WINGDIAPI
#define WINGDIAPI __declspec(dllimport)
#endif
#ifndef APIENTRY
#define APIENTRY __stdcall
#endif
#ifndef CALLBACK
#define CALLBACK __stdcall
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#ifndef GL_POLYGON_OFFSET_LINE
#define GL_POLYGON_OFFSET_LINE 0x2A02
#endif

// Some missing functions
typedef void (APIENTRY * PFNGLBINDTEXTURE)(GLenum target, GLuint texture);
typedef void (APIENTRY * PFNGLGENTEXTURES)(GLsizei n, GLuint *textures);
typedef void (APIENTRY * PFNGLDELETETEXTURES)(GLsizei n, const GLuint *textures);
typedef void (APIENTRY * PFNGLPOLYGONOFFSET)(GLfloat factor, GLfloat units);

extern PFNGLBINDTEXTURE glBindTexture;
extern PFNGLGENTEXTURES glGenTextures;
extern PFNGLDELETETEXTURES glDeleteTextures;
extern PFNGLPOLYGONOFFSET glPolygonOffset;

void InitializeMissingOpenGLFunctions();

#endif

#endif
