#ifndef NO_OPENGL
#include <windows.h>
#include "DebugAssert.h"
#include "OpenGL.h"

PFNGLBINDTEXTURE glBindTexture;
PFNGLGENTEXTURES glGenTextures;
PFNGLDELETETEXTURES glDeleteTextures;
PFNGLPOLYGONOFFSET glPolygonOffset;

#define GLIMP(name) { void* p = xxLoadProc( #name ); DEBUG_ASSERT(p, "failed to load OpenGL function"); memcpy(&name, &p, 4); }

static void* xxLoadProc(const char* name)
{
    void* p = wglGetProcAddress(name);
    if (p == 0 || p == (void*)1 || p == (void*)2 || p == (void*)3 || p == (void*)-1)
    {
        static HMODULE mod = LoadLibrary("opengl32.dll");
        DEBUG_ASSERT(mod, "failed to load OpenGL32.dll");
        p = GetProcAddress(mod, name);
    }
    DEBUG_ASSERT(p, "failed to find the function");
    return p;
}

void InitializeMissingOpenGLFunctions()
{
    static bool ok = false;
    if (ok) return;
    ok = true;

    GLIMP(glBindTexture);
    GLIMP(glGenTextures);
    GLIMP(glDeleteTextures);
    GLIMP(glPolygonOffset);
}

#endif
