//---------------------------------------------------------------------------
#ifndef HitTestH
#define HitTestH
//---------------------------------------------------------------------------
#include "Segment.h"
//---------------------------------------------------------------------------
// Helper hit test functions that do not belong to a specific class
namespace NHitTest
{
    // Hit test between a segment and a sphere
    template <typename T> inline bool TSegmentSphere(const TSegment<T>& s, const TVector<T>& c, T r, TVector<T>& ip)
    {
        TVector<T> d = (s.B - s.A).GetNormalized3D();
        TVector<T> so = s.A - c;
        T bb = NVector::TDot3D(so, d);
        double cc = so.GetLengthSquared3D() - r*r;  // Use double here to avoid imprecision errors
        double dd = bb*bb - cc;
        if (dd > 0.0)
        {
            T e = (T)sqrt(dd);
            T t0 = -bb-e, t1 = -bb+e;
            T t = t1 < t0 ? t1 : t0;
            if (t < 0.0f) return false;
            ip = s.A + d*t;
            return true;
        }
        return false;
    }
    template <typename T> inline bool TSegmentSphere(const TSegment<T>& s, const TVector<T>& c, T r)
    {
        TVector<T> d = (s.B - s.A).GetNormalized3D();
        TVector<T> so = s.A - c;
        T bb = NVector::TDot3D(so, d);
        double cc = so.GetLengthSquared3D() - r*r;  // Use double here to avoid imprecision errors          
        double dd = bb*bb - cc;
        if (dd > 0.0f)
        {
            T e = (T)sqrt(dd);
            T t0 = -bb-e, t1 = -bb+e;
            T t = t1 < t0 ? t1 : t0;
            if (t < 0.0f) return false;
            return true;
        }
        return false;
    }
    template <typename T> inline bool TSegmentBox3D(const TSegment<T>& s, const TVector<T>& a, const TVector<T>& b, TVector<T>& ip)
    {
        TVector<T> t, p;
        TVector<T> d = s.B - s.A;
        const T box[6] = {a.X, a.Y, a.Z, b.X, b.Y, b.Z};
        int i, gi = -1;
        if (NVector::TInBox3D(s.A, a, b)) {
            ip = s.A;
            return true;
        }
        if (NVector::TInBox3D(s.B, a, b)) {
            ip = s.B;
            return true;
        }
        for (i=0; i < 3; i++)
            t[i] = d[i] == 0.0f ? 0.0f : (box[d[i] > 0.0f ? i : i + 3] - s.A[i])/d[i];
        for (i=0; i < 3; i++) if (t[i] >= 0.0f && t[i] <= 1.0f) {
            p = s.A + d*t[i];
            if (NVector::TInBox3D(p, a, b)) {
                if (gi == -1 || t[i] < t[gi]) {
                    gi = i;
                    ip = p;
                }
            }
        }
        return gi != -1;
    }
}
//---------------------------------------------------------------------------
#endif
