//---------------------------------------------------------------------------
#ifndef HashFuncH
#define HashFuncH
//---------------------------------------------------------------------------
#include "DynArray.h"
//---------------------------------------------------------------------------
// Hash functions
namespace NHash
{
    // Raw function
    inline unsigned Raw(const char* value, unsigned len)
    {
        unsigned hash = 5381;
        for (unsigned i=0; i < len; ++i)
        {
            hash = ((hash << 5) + hash) + (unsigned)value[i];
        }
        return hash;
    }
    // Dynamic array
    template <typename T> inline unsigned Func(const TDynArray<T>& value)
    {
        unsigned hash = 5381;
        for (unsigned i=0; i < value.GetSize(); ++i)
        {
            hash = ((hash << 5) + hash) + NHash::Func(value[i]);
        }
        return hash;
    }
}
// Generic (simple) data types
#define NHASH_GENERIC(t) \
    namespace NHash { inline unsigned Func(t value) { return NHash::Raw((const char*)&value, sizeof(t)); } }
NHASH_GENERIC(char);
NHASH_GENERIC(short);
NHASH_GENERIC(int);
NHASH_GENERIC(long);
NHASH_GENERIC(__int64);
NHASH_GENERIC(unsigned char);
NHASH_GENERIC(unsigned short);
NHASH_GENERIC(unsigned int);
NHASH_GENERIC(unsigned long);
NHASH_GENERIC(unsigned __int64);
NHASH_GENERIC(float);
NHASH_GENERIC(double);
NHASH_GENERIC(const void*);
#ifdef __BORLANDC__
#include <vcl/dstring.h>
namespace NHash
{
    // AnsiString
    inline unsigned Func(const AnsiString& value)
    {
        return Raw(value.c_str(), value.Length());
    }
}
#endif
//---------------------------------------------------------------------------
#endif
