//---------------------------------------------------------------------------
#ifndef DocNodesH
#define DocNodesH
//---------------------------------------------------------------------------
#include "Nodes.h"
//---------------------------------------------------------------------------
// Forward class declarations
class CDocument;
//---------------------------------------------------------------------------
// A node that is part of the data represented by a document
class CDocNode : public CNode
{
    friend class CDocRootNode;
public:
    // Mark the document associated with this node (if any) as modified
    void MarkModified();
    // Returns the document associated with this node
    virtual CDocument* GetDocument() const;
protected:
    // CNode
#ifdef DEBUG
    virtual void OnChildAdded(CNode* child);
#endif
};
//---------------------------------------------------------------------------
// Root node in a CDocNode hierarchy, used to store the document reference
class CDocRootNode : public CDocNode
{
public:
    // Construct a root node with the given document
    CDocRootNode(CDocument* document)
        : m_document(document)
    {
        DEBUG_ASSERT(document, "Null document was given");
    }
public:
    // CDocNode
    virtual CDocument* GetDocument() const { return m_document; }
private:
    CDocument*      m_document;     // The document
};
//---------------------------------------------------------------------------
#endif
