//---------------------------------------------------------------------------
#include <stdio.h>
#include "DocNodes.h"
#include "Documents.h"
//---------------------------------------------------------------------------
// CDocNode implementation
void CDocNode::MarkModified()
{
    if (GetDocument()) GetDocument()->MarkModified();
}
//---------------------------------------------------------------------------
CDocument* CDocNode::GetDocument() const
{
    if (GetParent()) return static_cast<CDocNode*>(GetParent())->GetDocument();
    DEBUG_FAIL("Reached the root of the CDocNode tree without any node containing the document");
    return NULL;
}
//---------------------------------------------------------------------------
#ifdef DEBUG
void CDocNode::OnChildAdded(CNode* child)
{
    DEBUG_ASSERT(dynamic_cast<CDocNode*>(child), "Tried to add a non-CDocNode child to a CDocNode");
}
#endif
//---------------------------------------------------------------------------

