//---------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#ifndef NO_OPENGL
#include "OpenGL.h"
#endif
#include "DebugAssert.h"
//---------------------------------------------------------------------
#ifndef NO_OPENGL
static char LOpenGLErrorMessage[1024];
static unsigned LOpenGLErrorCode = 0;
static const char* LNoError = "no error";
static const char* LOpenGLErrorMessagePtr = LNoError;
#endif
//---------------------------------------------------------------------
// The message box thread
static DWORD WINAPI MsgBoxThread(LPVOID parameter)
{
    const char* msg = (const char*)parameter;
    MessageBoxA(NULL, msg, "Assertion Failed", MB_ICONERROR | MB_OK);
    return 0;
}
//---------------------------------------------------------------------
bool HandleDebugAssert(bool expr, const char* exprstr, const char* msg, const char* file, int line)
{
    if (!expr)
    {
        // After an assert fails, the program will try to repeatedly re-do whatever asserted
        // Try to avoid that by exiting the program the second time
        static bool alreadyAsserted = false;
        if (alreadyAsserted)
        {
            TerminateProcess(GetCurrentProcess(), 0);
            return false; // shouldn't reach that
        }
        alreadyAsserted = true;

        // Compose the message to show
        AnsiString fmsg = "Assertion Failed at " + AnsiString(file) + " line " + IntToStr(line);
        fmsg += "\r\n\r\nExpression:\r\n    " + AnsiString(exprstr) + "\r\n\r\nMessage:\r\n    " + AnsiString(msg);
        #ifndef NO_OPENGL
        fmsg += "\r\n\r\nLast OpenGL Error:\r\n    " + AnsiString(LOpenGLErrorMessagePtr) + " (" + IntToStr(LOpenGLErrorCode) + ")";
        #endif

        // Since we might be inside an event handler, use another thread to display the message box
        HANDLE thread = CreateThread(NULL, 0, MsgBoxThread, fmsg.c_str(), 0, NULL);
        DWORD code;
        while (GetExitCodeThread(thread, &code))
        {
            if (code != STILL_ACTIVE) break;
            Sleep(20);
        }
        CloseHandle(thread);
    }
    return !expr;
}
//---------------------------------------------------------------------
void PostDebugAssertExit()
{
    TerminateProcess(GetCurrentProcess(), 0);
}
//---------------------------------------------------------------------
unsigned GetTheGLError()
{
#ifndef NO_OPENGL
    GLenum err = glGetError();
    if (err == GL_NO_ERROR)
    {
        LOpenGLErrorMessagePtr = LNoError;
    }
    else
    {
        strncpy(LOpenGLErrorMessage, (const char*)gluErrorString(err), sizeof(LOpenGLErrorMessage) - 1);
        LOpenGLErrorMessagePtr = LOpenGLErrorMessage;
    }
    return err;
#else
    return 0;
#endif
}
//---------------------------------------------------------------------
